"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pickFromObjectSchema = pickFromObjectSchema;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Picks a subset of props from base schema definition
 *
 * TODO: move this to shared package, maybe `@kbn/config-schema`
 */
function pickFromObjectSchema(schema, keys) {
  // Note: Assign type is required to prevent omitted key pollution on spread

  // lodash.pick types do not infer the object type to enforce keyof T
  return (0, _lodash.pick)(schema, keys);
}