"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensEmbeddableComponent = LensEmbeddableComponent;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _react = _interopRequireWildcard(require("react"));
var _expression_wrapper = require("../expression_wrapper");
var _container = require("../user_messages/container");
var _hooks = require("./hooks");
var _helper = require("../helper");
var _logger = require("../logger");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/react_embeddable/renderer/lens_embeddable_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function LensEmbeddableComponent({
  internalApi,
  api,
  onUnmount
}) {
  var _api$isEditingEnabled, _api$description$, _api$description$$get, _api$description$2, _api$defaultDescripti;
  const [
  // Pick up updated params from the observable
  expressionParams,
  // used for functional tests
  renderCount,
  // these are blocking errors that can be shown in a badge
  // without replacing the entire panel
  blockingErrors,
  // has the render completed?
  hasRendered] = (0, _presentationPublishing.useBatchedPublishingSubjects)(internalApi.expressionParams$, internalApi.renderCount$, internalApi.validationMessages$, api.rendered$,
  // listen to view change mode but do not use its actual value
  // just call the Lens API to know whether it's in edit mode
  api.viewMode$);
  const canEdit = Boolean(((_api$isEditingEnabled = api.isEditingEnabled) === null || _api$isEditingEnabled === void 0 ? void 0 : _api$isEditingEnabled.call(api)) && (0, _helper.getViewMode)(api) === 'edit');
  const [warningOrErrors, infoMessages] = (0, _hooks.useMessages)(internalApi);

  // On unmount call all the cleanups
  (0, _react.useEffect)(() => {
    var _api$defaultTitle$;
    (0, _logger.addLog)(`Mounting Lens Embeddable component: ${(_api$defaultTitle$ = api.defaultTitle$) === null || _api$defaultTitle$ === void 0 ? void 0 : _api$defaultTitle$.getValue()}`);
    return onUnmount;
  }, [api, onUnmount]);

  // take care of dispatching the event from the DOM node
  const rootRef = (0, _hooks.useDispatcher)(hasRendered, api);

  // Publish the data attributes only if avaialble/visible
  const title = (0, _react.useMemo)(() => {
    var _internalApi$getDispl, _api$title$$getValue, _api$title$, _api$defaultTitle$2;
    return (_internalApi$getDispl = internalApi.getDisplayOptions()) !== null && _internalApi$getDispl !== void 0 && _internalApi$getDispl.noPanelTitle ? undefined : {
      'data-title': (_api$title$$getValue = (_api$title$ = api.title$) === null || _api$title$ === void 0 ? void 0 : _api$title$.getValue()) !== null && _api$title$$getValue !== void 0 ? _api$title$$getValue : (_api$defaultTitle$2 = api.defaultTitle$) === null || _api$defaultTitle$2 === void 0 ? void 0 : _api$defaultTitle$2.getValue()
    };
  }, [api.defaultTitle$, api.title$, internalApi]);
  const description = (_api$description$ = api.description$) !== null && _api$description$ !== void 0 && _api$description$.getValue() ? {
    'data-description': (_api$description$$get = (_api$description$2 = api.description$) === null || _api$description$2 === void 0 ? void 0 : _api$description$2.getValue()) !== null && _api$description$$get !== void 0 ? _api$description$$get : (_api$defaultDescripti = api.defaultDescription$) === null || _api$defaultDescripti === void 0 ? void 0 : _api$defaultDescripti.getValue()
  } : undefined;
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    css: {
      width: '100%',
      height: '100%',
      position: 'relative'
    },
    "data-rendering-count": renderCount + 1,
    "data-render-complete": hasRendered
  }, title, description, {
    "data-shared-item": true,
    ref: rootRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }), expressionParams == null || blockingErrors.length ? null : /*#__PURE__*/_react.default.createElement(_expression_wrapper.ExpressionWrapper, (0, _extends2.default)({}, expressionParams, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_container.UserMessages, {
    blockingErrors: blockingErrors,
    warningOrErrors: warningOrErrors,
    infoMessages: infoMessages,
    canEdit: canEdit,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }));
}