"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSharedActions = exports.LayerActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _clone_layer_action = require("./clone_layer_action");
var _remove_layer_action = require("./remove_layer_action");
var _open_layer_settings = require("./open_layer_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/config_panel/layer_actions/layer_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/** @internal **/
const getSharedActions = ({
  core,
  layerIndex,
  layerType,
  activeVisualization,
  isOnlyLayer,
  isTextBasedLanguage,
  hasLayerSettings,
  openLayerSettings,
  onCloneLayer,
  onRemoveLayer,
  customRemoveModalText
}) => [(0, _open_layer_settings.getOpenLayerSettingsAction)({
  hasLayerSettings,
  openLayerSettings
}), (0, _clone_layer_action.getCloneLayerAction)({
  execute: onCloneLayer,
  layerIndex,
  activeVisualization,
  isTextBasedLanguage
}), (0, _remove_layer_action.getRemoveLayerAction)({
  execute: onRemoveLayer,
  layerIndex,
  layerType,
  isOnlyLayer,
  core,
  customModalText: customRemoveModalText
})];

/** @internal **/
exports.getSharedActions = getSharedActions;
const InContextMenuActions = props => {
  const dataTestSubject = `lnsLayerSplitButton--${props.layerIndex}`;
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const splitButtonPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: dataTestSubject
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onButtonClick = (0, _react.useCallback)(() => {
    setPopover(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    if (isPopoverOpen) {
      setPopover(false);
    }
  }, [isPopoverOpen]);

  // `neutral` and `risk` variants belong to `severity` so they're not
  // available in `euiTheme.colors` directly
  const getColorFromTheme = (0, _react.useCallback)(color => color === 'risk' || color === 'neutral' ? euiTheme.colors.severity[color] : euiTheme.colors[color], [euiTheme]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: splitButtonPopoverId,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "empty",
      color: "text",
      size: "s",
      iconType: "boxesVertical",
      "aria-label": _i18n.i18n.translate('xpack.lens.layer.actions.contextMenuAriaLabel', {
        defaultMessage: `Layer actions`
      }),
      onClick: onButtonClick,
      "data-test-subj": dataTestSubject,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }),
    ownFocus: true,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    panelProps: {
      'data-test-subj': 'lnsLayerActionsMenu'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: props.actions.map(i => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
      key: i.displayName,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: i.icon,
        title: i.displayName,
        color: i.color,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 21
        }
      }),
      "data-test-subj": i['data-test-subj'],
      "aria-label": i.displayName,
      title: i.displayName,
      disabled: i.disabled,
      onClick: () => {
        closePopover();
        i.execute(props.mountingPoint);
      }
    }, i.color ? {
      css: (0, _react2.css)`
                      color: ${getColorFromTheme(i.color)};
                      &:hover {
                        text-decoration-color: ${getColorFromTheme(i.color)} !important;
                      }
                    `,
      size: 's' // need to be explicit here as css prop will disable the default small size
    } : {}, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 's',
      color: i.color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 15
      }
    }, i.displayName))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  })));
};
const LayerActions = props => {
  var _outsideListAction$co;
  if (!props.actions.length) {
    return null;
  }
  const sortedActions = [...props.actions].sort(({
    order: order1
  }, {
    order: order2
  }) => order1 - order2);
  const outsideListAction = sortedActions.length === 1 ? sortedActions[0] : sortedActions.find(action => action.showOutsideList);
  const listActions = sortedActions.filter(action => action !== outsideListAction);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
        gap: 0;
      `,
    responsive: false,
    alignItems: "center",
    direction: "row",
    justifyContent: "flexEnd",
    "data-test-subj": "lnsLayerActions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 5
    }
  }, outsideListAction && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: outsideListAction.displayName,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    iconType: outsideListAction.icon,
    color: (_outsideListAction$co = outsideListAction.color) !== null && _outsideListAction$co !== void 0 ? _outsideListAction$co : 'text',
    "data-test-subj": outsideListAction['data-test-subj'],
    "aria-label": outsideListAction.displayName,
    title: outsideListAction.displayName,
    disabled: outsideListAction.disabled,
    onClick: () => {
      var _outsideListAction$ex;
      return (_outsideListAction$ex = outsideListAction.execute) === null || _outsideListAction$ex === void 0 ? void 0 : _outsideListAction$ex.call(outsideListAction, props.mountingPoint);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(InContextMenuActions, (0, _extends2.default)({}, props, {
    actions: listActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 9
    }
  }))));
};
exports.LayerActions = LayerActions;