"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCurrentAttributes = void 0;
var _react = require("react");
var _helper = require("../../../react_embeddable/helper");
var _state_management = require("../../../state_management");
var _utils = require("../../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCurrentAttributes = ({
  textBasedMode,
  initialAttributes,
  datasourceMap,
  visualizationMap
}) => {
  var _visualization$active;
  const {
    datasourceStates,
    visualization,
    activeDatasourceId
  } = (0, _state_management.useLensSelector)(state => state.lens);

  // use the latest activeId, but fallback to attributes
  const visualizationType = (_visualization$active = visualization.activeId) !== null && _visualization$active !== void 0 ? _visualization$active : initialAttributes === null || initialAttributes === void 0 ? void 0 : initialAttributes.visualizationType;
  const activeVisualization = visualizationType ? visualizationMap[visualizationType] : undefined;
  const currentAttributes = (0, _react.useMemo)(() => {
    if (!activeVisualization) {
      return initialAttributes;
    }
    const dsStates = Object.fromEntries(Object.entries(datasourceStates).map(([id, ds]) => {
      const dsState = ds.state;
      return [id, dsState];
    }));
    // as ES|QL queries are using adHoc dataviews, we don't want to pass references
    const references = !textBasedMode && visualization.state ? (0, _utils.extractReferencesFromState)({
      activeDatasourceId,
      activeDatasources: Object.keys(datasourceStates).reduce((acc, id) => ({
        ...acc,
        [id]: datasourceMap[id]
      }), {}),
      datasourceStates,
      visualizationState: visualization.state,
      activeVisualization
    }) : [];
    const attributes = initialAttributes !== null && initialAttributes !== void 0 ? initialAttributes : (0, _helper.createEmptyLensState)().attributes;
    const attrs = {
      ...attributes,
      state: {
        ...attributes.state,
        visualization: visualization.state,
        datasourceStates: dsStates
      },
      references,
      visualizationType: activeVisualization.id
    };
    return attrs;
  }, [activeDatasourceId, activeVisualization, datasourceMap, datasourceStates, initialAttributes, textBasedMode, visualization.state]);
  return currentAttributes;
};
exports.useCurrentAttributes = useCurrentAttributes;