"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineTreeNodeLabel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/packages/shared/ingest-pipelines/src/components/pipeline_structure_tree/tree_node_labels/pipeline_tree_node_label.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PipelineTreeNodeLabel = ({
  pipelineName,
  isManaged,
  isDeprecated
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    css: {
      width: '350px'
    },
    alignItems: "center",
    "data-test-subj": `pipelineTreeNode-${pipelineName}`,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 10 - Number(isDeprecated) - Number(isManaged),
    css: {
      textAlign: 'left'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, pipelineName), isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    "data-test-subj": `pipelineTreeNode-${pipelineName}-managedIcon`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('ingestPipelines.pipelineStructureTree.treeNodeManagedTooltip', {
      defaultMessage: 'Managed'
    }),
    type: "lock",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  })), isDeprecated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    "data-test-subj": `pipelineTreeNode-${pipelineName}-deprecatedIcon`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('ingestPipelines.pipelineStructureTree.treeNodeDeprecatedTooltip', {
      defaultMessage: 'Deprecated'
    }),
    type: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  })));
};
exports.PipelineTreeNodeLabel = PipelineTreeNodeLabel;