"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Split = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _field_name_field = require("./common_fields/field_name_field");
var _target_field = require("./common_fields/target_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _shared = require("./shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/split.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  emptyField
} = _shared_imports.fieldValidators;
const fieldsConfig = {
  /* Required fields config */
  separator: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.splitForm.separatorFieldLabel', {
      defaultMessage: 'Separator'
    }),
    deserializer: String,
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.splitForm.separatorFieldHelpText', {
      defaultMessage: 'Regex pattern used to delimit the field value.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.splitForm.separatorRequiredError', {
        defaultMessage: 'A value is required.'
      }))
    }]
  },
  /* Optional fields config */
  preserve_trailing: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.splitForm.preserveTrailingFieldLabel', {
      defaultMessage: 'Preserve trailing'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.splitForm.preserveTrailingFieldHelpText', {
      defaultMessage: 'Preserve any trailing whitespace in the split field values.'
    })
  }
};
const Split = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.splitForm.fieldNameHelpText', {
      defaultMessage: 'Field to split.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.separator,
    component: _shared_imports.Field,
    path: "fields.separator",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.preserve_trailing,
    component: _shared_imports.ToggleField,
    path: "fields.preserve_trailing",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }));
};
exports.Split = Split;