"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Convert = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _field_name_field = require("./common_fields/field_name_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _target_field = require("./common_fields/target_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/convert.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  emptyField
} = _shared_imports.fieldValidators;
const fieldsConfig = {
  /* Required fields config */
  type: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    defaultValue: '',
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.typeFieldLabel', {
      defaultMessage: 'Type'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.typeFieldHelpText', {
      defaultMessage: 'Field data type for the output.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.typeRequiredError', {
        defaultMessage: 'A type value is required.'
      }))
    }]
  }
};
const Convert = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.fieldNameHelpText', {
      defaultMessage: 'Field to convert.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'typeSelectorField',
        options: [{
          value: 'integer',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.integerOption', {
            defaultMessage: 'Integer'
          })
        }, {
          value: 'long',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.longOption', {
            defaultMessage: 'Long'
          })
        }, {
          value: 'float',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.floatOption', {
            defaultMessage: 'Float'
          })
        }, {
          value: 'double',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.doubleOption', {
            defaultMessage: 'Double'
          })
        }, {
          value: 'string',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.stringOption', {
            defaultMessage: 'String'
          })
        }, {
          value: 'boolean',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.booleanOption', {
            defaultMessage: 'Boolean'
          })
        }, {
          value: 'ip',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.ipOption', {
            defaultMessage: 'IP'
          })
        }, {
          value: 'auto',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.autoOption', {
            defaultMessage: 'Auto'
          })
        }]
      }
    },
    config: fieldsConfig.type,
    component: _shared_imports.SelectField,
    path: "fields.type",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }));
};
exports.Convert = Convert;