"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogAnalysisModuleListCard = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _create_job_button = require("../create_job_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_setup/setup_flyout/module_list_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogAnalysisModuleListCard = ({
  jobId,
  hasSetupCapabilities,
  moduleDescription,
  moduleName,
  moduleStatus,
  onViewSetup
}) => {
  const {
    services: {
      ml,
      application: {
        navigateToUrl
      },
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const isComponentMounted = (0, _useMountedState.default)();
  const [viewInMlLink, setViewInMlLink] = (0, _react.useState)('');
  const getMlUrl = (0, _react.useCallback)(async () => {
    if (!(ml !== null && ml !== void 0 && ml.managementLocator)) {
      toasts.addWarning({
        title: mlNotAvailableMessage
      });
      return;
    }

    // Get link to ML anomaly detection management job list
    // with filter to jobId
    const link = await ml.managementLocator.getUrl({
      page: '',
      pageState: {
        jobId
      }
    }, 'anomaly_detection');
    if (link !== null && link !== void 0 && link.url && isComponentMounted()) {
      setViewInMlLink(link.url);
    }
  }, [jobId, ml === null || ml === void 0 ? void 0 : ml.managementLocator, toasts, isComponentMounted]);
  (0, _react.useEffect)(function getMlAnomalyDetectionJobLink() {
    getMlUrl();
  }, [getMlUrl]);
  const navigateToMlApp = async () => {
    await navigateToUrl(viewInMlLink);
  };
  const moduleIcon = moduleStatus.type === 'required' ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xxl",
    type: "machineLearningApp",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "success",
    size: "xxl",
    type: "check",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  });
  const moduleSetupButton = moduleStatus.type === 'required' ? /*#__PURE__*/_react.default.createElement(_create_job_button.CreateJobButton, {
    hasSetupCapabilities: hasSetupCapabilities,
    onClick: onViewSetup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.analysis.enableAnomalyDetectionButtonLabel",
    defaultMessage: "Enable anomaly detection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_create_job_button.RecreateJobButton, {
    hasSetupCapabilities: hasSetupCapabilities,
    onClick: onViewSetup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }), viewInMlLink ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraLogAnalysisModuleListCardViewInMachineLearningButton",
    onClick: navigateToMlApp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.analysis.viewInMlButtonLabel",
    defaultMessage: "View in Machine Learning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 15
    }
  }))) : null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    description: moduleDescription,
    footer: /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 15
      }
    }, moduleSetupButton),
    icon: moduleIcon,
    title: moduleName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  });
};
exports.LogAnalysisModuleListCard = LogAnalysisModuleListCard;
const mlNotAvailableMessage = _i18n.i18n.translate('xpack.infra.logs.analysis.mlNotAvailable', {
  defaultMessage: 'ML plugin is not available'
});