"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.staticMetricsExplorerViewId = exports.staticMetricsExplorerViewAttributes = void 0;
var _i18n = require("@kbn/i18n");
var _color_palette = require("../color_palette");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const staticMetricsExplorerViewId = exports.staticMetricsExplorerViewId = '0';
const staticMetricsExplorerViewAttributes = exports.staticMetricsExplorerViewAttributes = {
  name: _i18n.i18n.translate('xpack.infra.savedView.defaultViewNameHosts', {
    defaultMessage: 'Default view'
  }),
  isDefault: false,
  isStatic: true,
  options: {
    aggregation: 'avg',
    metrics: [{
      aggregation: 'avg',
      field: 'system.cpu.total.norm.pct',
      color: _color_palette.Color.color0
    }, {
      aggregation: 'avg',
      field: 'kubernetes.pod.cpu.usage.node.pct',
      color: _color_palette.Color.color1
    }, {
      aggregation: 'avg',
      field: 'docker.cpu.total.pct',
      color: _color_palette.Color.color2
    }],
    source: 'default'
  },
  chartOptions: {
    type: _types.MetricsExplorerChartType.line,
    yAxisMode: _types.MetricsExplorerYAxisMode.fromZero,
    stack: false
  },
  currentTimerange: {
    from: 'now-1h',
    to: 'now',
    interval: '>=10s'
  }
};