"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataSender = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MetadataSender {
  constructor(logger, analytics) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.analytics = analytics;
    this.logger = logger.get(MetadataSender.name);
  }
  reportEBT(eventTypeOpts, eventData) {
    this.logger.debug('Reporting event', {
      eventType: eventTypeOpts.eventType
    });
    this.analytics.reportEvent(eventTypeOpts.eventType, eventData);
  }
}
exports.MetadataSender = MetadataSender;