"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _index_mode_labels = require("../../../../lib/index_mode_labels");
var _services = require("../../../../services");
var _notification = require("../../../../services/notification");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/create_index/create_index_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INVALID_INDEX_NAME_ERROR = _i18n.i18n.translate('xpack.idxMgmt.createIndex.modal.invalidName.error', {
  defaultMessage: 'Index name is not valid'
});
const CreateIndexModal = ({
  closeModal,
  loadIndices
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [indexName, setIndexName] = (0, _react.useState)('');
  const [indexMode, setIndexMode] = (0, _react.useState)(_constants.STANDARD_INDEX_MODE);
  const [indexNameError, setIndexNameError] = (0, _react.useState)();
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [createError, setCreateError] = (0, _react.useState)();
  const putCreateIndex = (0, _react.useCallback)(async () => {
    setIsSaving(true);
    try {
      const {
        error
      } = await (0, _services.createIndex)(indexName, indexMode);
      setIsSaving(false);
      if (!error) {
        _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.createIndex.successfullyCreatedIndexMessage', {
          defaultMessage: 'Successfully created index: {indexName}',
          values: {
            indexName
          }
        }));
        closeModal();
        loadIndices();
        return;
      }
      setCreateError(error.message);
    } catch (e) {
      setIsSaving(false);
      setCreateError(e.message);
    }
  }, [closeModal, indexMode, indexName, loadIndices]);
  const onSave = () => {
    if ((0, _utils.isValidIndexName)(indexName)) {
      putCreateIndex();
    }
  };
  const onNameChange = name => {
    setIndexName(name);
    if (!(0, _utils.isValidIndexName)(name)) {
      setIndexNameError(INVALID_INDEX_NAME_ERROR);
    } else if (indexNameError) {
      setIndexNameError(undefined);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: closeModal,
    initialFocus: "[name=indexName]",
    css: {
      width: 450
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.createIndex.modal.title",
    defaultMessage: "Create index",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, createError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "error",
    title: _i18n.i18n.translate('xpack.idxMgmt.createIndex.modal.error.title', {
      defaultMessage: 'Error creating index'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.createIndex.modal.error.description",
    defaultMessage: "Error creating index: {errorMessage}",
    values: {
      errorMessage: createError
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: "createIndexModalForm",
    component: "form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.idxMgmt.createIndex.modal.indexName.label', {
      defaultMessage: 'Index name'
    }),
    isDisabled: isSaving,
    isInvalid: indexNameError !== undefined,
    error: indexNameError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: indexNameError !== undefined,
    fullWidth: true,
    name: "indexName",
    value: indexName,
    onChange: e => onNameChange(e.target.value),
    "data-test-subj": "createIndexNameFieldText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.idxMgmt.createIndex.modal.indexMode.label', {
      defaultMessage: 'Index mode'
    }),
    isDisabled: isSaving,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    hasDividers: true,
    name: "indexMode",
    valueOfSelected: indexMode,
    onChange: mode => setIndexMode(mode),
    "data-test-subj": "indexModeField",
    options: [{
      value: _constants.STANDARD_INDEX_MODE,
      inputDisplay: _index_mode_labels.indexModeLabels[_constants.STANDARD_INDEX_MODE],
      'data-test-subj': 'indexModeStandardOption',
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 23
        }
      }, _index_mode_labels.indexModeLabels[_constants.STANDARD_INDEX_MODE]), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 25
        }
      }, _index_mode_labels.indexModeDescriptions[_constants.STANDARD_INDEX_MODE])))
    }, {
      value: _constants.LOOKUP_INDEX_MODE,
      inputDisplay: _index_mode_labels.indexModeLabels[_constants.LOOKUP_INDEX_MODE],
      'data-test-subj': 'indexModeLookupOption',
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 23
        }
      }, _index_mode_labels.indexModeLabels[_constants.LOOKUP_INDEX_MODE]), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 25
        }
      }, _index_mode_labels.indexModeDescriptions[_constants.LOOKUP_INDEX_MODE])))
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    disabled: isSaving,
    "data-test-subj": "createIndexCancelButton",
    "data-telemetry-id": "idxMgmt-indexList-createIndex-cancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.createIndex.modal.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: indexNameError !== undefined,
    isLoading: isSaving,
    type: "submit",
    onClick: onSave,
    form: "createIndexModalForm",
    "data-test-subj": "createIndexSaveButton",
    "data-telemetry-id": "idxMgmt-indexList-createIndex-saveButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.createIndex.modal.saveButton",
    defaultMessage: "Create",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 11
    }
  }))));
};
exports.CreateIndexModal = CreateIndexModal;