"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateDeleteModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _deleteManagedAssetCallout = require("@kbn/delete-managed-asset-callout");
var _api = require("../services/api");
var _notification = require("../services/notification");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/template_delete_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TemplateDeleteModal = ({
  templatesToDelete,
  callback
}) => {
  const [isDeleteConfirmed, setIsDeleteConfirmed] = (0, _react.useState)(false);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const numTemplatesToDelete = templatesToDelete.length;
  const hasSystemTemplate = Boolean(templatesToDelete.find(({
    name
  }) => name.startsWith('.')));
  const managedTemplatesToDelete = templatesToDelete.filter(({
    type
  }) => type === 'managed').length;
  const handleDeleteTemplates = () => {
    (0, _api.deleteTemplates)(templatesToDelete).then(({
      data: {
        templatesDeleted,
        errors
      },
      error
    }) => {
      const hasDeletedTemplates = templatesDeleted && templatesDeleted.length;
      if (hasDeletedTemplates) {
        const successMessage = templatesDeleted.length === 1 ? _i18n.i18n.translate('xpack.idxMgmt.deleteTemplatesModal.successDeleteSingleNotificationMessageText', {
          defaultMessage: "Deleted template ''{templateName}''",
          values: {
            templateName: templatesToDelete[0].name
          }
        }) : _i18n.i18n.translate('xpack.idxMgmt.deleteTemplatesModal.successDeleteMultipleNotificationMessageText', {
          defaultMessage: 'Deleted {numSuccesses, plural, one {# template} other {# templates}}',
          values: {
            numSuccesses: templatesDeleted.length
          }
        });
        callback({
          hasDeletedTemplates
        });
        _notification.notificationService.showSuccessToast(successMessage);
      }
      if (error || errors && errors.length) {
        const hasMultipleErrors = errors && errors.length > 1 || error && templatesToDelete.length > 1;
        const errorMessage = hasMultipleErrors ? _i18n.i18n.translate('xpack.idxMgmt.deleteTemplatesModal.multipleErrorsNotificationMessageText', {
          defaultMessage: 'Error deleting {count} templates',
          values: {
            count: errors && errors.length || templatesToDelete.length
          }
        }) : _i18n.i18n.translate('xpack.idxMgmt.deleteTemplatesModal.errorNotificationMessageText', {
          defaultMessage: "Error deleting template ''{name}''",
          values: {
            name: errors && errors[0].name || templatesToDelete[0]
          }
        });
        _notification.notificationService.showDangerToast(errorMessage);
      }
    });
  };
  const handleOnCancel = () => {
    setIsDeleteConfirmed(false);
    callback();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    buttonColor: "danger",
    "data-test-subj": "deleteTemplatesConfirmation",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteTemplatesModal.modalTitleText",
      defaultMessage: "Delete {numTemplatesToDelete, plural, one {template} other {# templates}}",
      values: {
        numTemplatesToDelete
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }),
    onCancel: handleOnCancel,
    onConfirm: handleDeleteTemplates,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteTemplatesModal.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteTemplatesModal.confirmButtonLabel",
      defaultMessage: "Delete {numTemplatesToDelete, plural, one {template} other {templates} }",
      values: {
        numTemplatesToDelete
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }),
    confirmButtonDisabled: hasSystemTemplate ? !isDeleteConfirmed : false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, managedTemplatesToDelete > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_deleteManagedAssetCallout.DeleteManagedAssetsCallout, {
    assetName: _i18n.i18n.translate('xpack.idxMgmt.deleteTemplatesModal.assetName', {
      defaultMessage: 'index templates'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.deleteTemplatesModal.deleteDescription",
    defaultMessage: "You are about to delete {numTemplatesToDelete, plural, one {this template} other {these templates} }:",
    values: {
      numTemplatesToDelete
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, templatesToDelete.map(({
    name,
    type
  }) => /*#__PURE__*/_react.default.createElement("li", {
    key: name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, name, type === 'managed' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.deleteTemplatesModal.managedTemplateLabel",
    defaultMessage: "Managed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 21
    }
  }))), name.startsWith('.') ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 17
    }
  }, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "warning",
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.deleteTemplatesModal.systemTemplateLabel",
    defaultMessage: "System template",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 21
    }
  }))) : null))), hasSystemTemplate && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteTemplatesModal.proceedWithCautionCallOutTitle",
      defaultMessage: "Deleting a system template can break Kibana",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 15
      }
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "deleteSystemTemplateCallOut",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.deleteTemplatesModal.proceedWithCautionCallOutDescription",
    defaultMessage: "System templates are critical for internal operations. If you delete this template, you can\u2019t recover it.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "confirmDeleteTemplatesCheckbox",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteTemplatesModal.confirmDeleteCheckboxLabel",
      defaultMessage: "I understand the consequences of deleting a system template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 17
      }
    }),
    checked: isDeleteConfirmed,
    onChange: e => setIsDeleteConfirmed(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 13
    }
  }))));
};
exports.TemplateDeleteModal = TemplateDeleteModal;