"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocValuesParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _edit_field = require("../fields/edit_field");
var _documentation = require("../../../../../services/documentation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/doc_values_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DocValuesParameter = ({
  configPath = 'doc_values'
}) => /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
  title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.docValuesFieldTitle', {
    defaultMessage: 'Use doc values'
  }),
  description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.docValuesFieldDescription', {
    defaultMessage: `Store each document's value for this field in memory so it can be used for sorting, aggregations, and in scripts.`
  }),
  docLink: {
    text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.docValuesDocLinkText', {
      defaultMessage: 'Doc values documentation'
    }),
    href: _documentation.documentationService.getDocValuesLink()
  },
  formFieldPath: "doc_values",
  configPath: configPath,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 22,
    columnNumber: 3
  }
});
exports.DocValuesParameter = DocValuesParameter;