"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _reactQuery = require("@kbn/react-query");
var _gen_ai_settings_app = require("../components/gen_ai_settings_app");
var _enabled_features_context = require("../contexts/enabled_features_context");
var _client = require("../api/client");
var _settings_context = require("../contexts/settings_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/gen_ai_settings/public/management_section/mount_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const mountManagementSection = async ({
  core,
  mountParams: {
    element,
    setBreadcrumbs,
    history
  },
  config
}) => {
  const [coreStart, startDeps] = await core.getStartServices();
  coreStart.chrome.docTitle.change(_i18n.i18n.translate('xpack.genAiSettings.app.titleBar', {
    defaultMessage: 'GenAI Settings'
  }));
  const genAiSettingsApi = (0, _client.createCallGenAiSettingsAPI)(coreStart);
  const queryClient = new _reactQuery.QueryClient();
  const GenAiSettingsAppWithContext = () => /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      ...startDeps,
      genAiSettingsApi
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_enabled_features_context.EnabledFeaturesContextProvider, {
    config: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_settings_context.SettingsContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_gen_ai_settings_app.GenAiSettingsApp, {
    setBreadcrumbs: setBreadcrumbs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 17
    }
  })))))));
  _reactDom.default.render((0, _reactKibanaContextTheme.wrapWithTheme)(/*#__PURE__*/_react.default.createElement(GenAiSettingsAppWithContext, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 33
    }
  }), core.theme), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.mountManagementSection = mountManagementSection;