"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExtensionRegistrationCallback = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Factory that returns a callback that can be used to register UI extensions */
const createExtensionRegistrationCallback = storage => {
  return extensionPoint => {
    var _storage$packageName;
    const {
      package: packageName,
      view
    } = extensionPoint;
    if (!storage[packageName]) {
      storage[packageName] = {};
    }
    if ((_storage$packageName = storage[packageName]) !== null && _storage$packageName !== void 0 && _storage$packageName[view]) {
      throw new Error(`Extension point has already been registered: [${packageName}][${view}]`);
    }
    storage[packageName][view] = extensionPoint;
  };
};
exports.createExtensionRegistrationCallback = createExtensionRegistrationCallback;