"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallAzureArmTemplateManagedAgentStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _azure_arm_template_instructions = require("./azure_arm_template_instructions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/cloud_security_posture/install_azure_arm_template_managed_agent_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const InstallAzureArmTemplateManagedAgentStep = ({
  selectedApiKeyId,
  apiKeyData,
  enrollToken,
  isComplete,
  cloudSecurityIntegration,
  agentPolicy
}) => {
  const nonCompleteStatus = selectedApiKeyId ? undefined : 'disabled';
  const status = isComplete ? 'complete' : nonCompleteStatus;
  return {
    status,
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.azureArmTemplate.stepEnrollAndRunAgentTitle', {
      defaultMessage: 'Install Elastic Agent on your cloud'
    }),
    children: selectedApiKeyId && apiKeyData && cloudSecurityIntegration ? /*#__PURE__*/_react.default.createElement(_azure_arm_template_instructions.AzureArmTemplateInstructions, {
      cloudSecurityIntegration: cloudSecurityIntegration,
      enrollmentAPIKey: enrollToken,
      agentPolicy: agentPolicy,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    })
  };
};
exports.InstallAzureArmTemplateManagedAgentStep = InstallAzureArmTemplateManagedAgentStep;