"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardsButtons = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _dashboard_helpers = require("../../services/dashboard_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/dashboards_buttons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useDashboardExists = dashboardId => {
  const {
    dashboard: dashboardPlugin
  } = (0, _hooks.useStartServices)();
  const {
    data,
    isLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: ['dashboard_exists', dashboardId],
    queryFn: async () => {
      try {
        const findDashboardsService = await dashboardPlugin.findDashboardsService();
        const [dashboard] = await findDashboardsService.findByIds([dashboardId]);
        return (dashboard === null || dashboard === void 0 ? void 0 : dashboard.status) === 'success';
      } catch (e) {
        return false;
      }
    }
  });
  return {
    dashboardExists: data !== null && data !== void 0 ? data : false,
    loading: isLoading
  };
};
const DashboardsButtons = () => {
  const {
    data
  } = (0, _hooks.useGetPackageInfoByKeyQuery)(_constants.FLEET_ELASTIC_AGENT_PACKAGE);
  const {
    spaceId
  } = (0, _hooks.useFleetStatus)();
  const dashboardLocator = (0, _hooks.useDashboardLocator)();
  const getDashboardHref = dashboardId => {
    return (dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
      dashboardId
    })) || '';
  };
  const elasticAgentOverviewDashboardId = (0, _dashboard_helpers.getDashboardIdForSpace)(spaceId, data, _constants.DASHBOARD_LOCATORS_IDS.ELASTIC_AGENT_OVERVIEW);
  const elasticAgentInfoDashboardId = (0, _dashboard_helpers.getDashboardIdForSpace)(spaceId, data, _constants.DASHBOARD_LOCATORS_IDS.ELASTIC_AGENT_AGENT_INFO);
  const {
    dashboardExists,
    loading: dashboardLoading
  } = useDashboardExists(elasticAgentOverviewDashboardId);
  if (dashboardLoading || !dashboardExists) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "dashboardApp",
    href: getDashboardHref(elasticAgentOverviewDashboardId),
    "data-test-subj": "ingestOverviewLinkButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.ingestOverviewlinkButton",
    defaultMessage: "Ingest Overview Metrics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "dashboardApp",
    href: getDashboardHref(elasticAgentInfoDashboardId),
    "data-test-subj": "agentInfoLinkButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.agentInfoLinkButton",
    defaultMessage: "Agent Info Metrics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  })))));
};
exports.DashboardsButtons = DashboardsButtons;