"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmIncomingDataWithPreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _lodash = require("lodash");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_get_agent_incoming_data = require("../../../../../../../components/agent_enrollment_flyout/use_get_agent_incoming_data");
var _confirm_incoming_data_timeout = require("./confirm_incoming_data_timeout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/multi_page_layout/components/confirm_incoming_data_with_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MAX_AGENT_DATA_PREVIEW_COUNT = 5;
// make room for more interesting keys in the UI
const DATA_PREVIEW_OMIT_KEYS = ['agent.ephemeral_id', 'agent.id', 'elastic_agent.id', 'data_stream.namespace', '@timestamp'];
const CleanOverflowDescriptionList = (0, _styledComponents.default)(_eui.EuiDescriptionList)`
  overflow: hidden;
  max-height: 125px;
  word-break: break-all;
  white-space: pre-wrap;
`;

// &&& increases the style priority
const CompressedPre = (0, _styledComponents.default)('pre')`
  &&& {
    background: none;
    padding: 0 0;
  }
`;
const HitPreview = ({
  hit
}) => {
  const hitForDisplay = (0, _lodash.omit)((0, _std.getFlattenedObject)(hit._source), DATA_PREVIEW_OMIT_KEYS);
  const listItems = Object.entries(hitForDisplay).map(([key, value]) => ({
    title: `${key}:`,
    // Ensures arrays and collections of nested objects are displayed correctly
    description: JSON.stringify(value)
  }));
  return /*#__PURE__*/_react.default.createElement("pre", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("code", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(CleanOverflowDescriptionList, {
    listItems: listItems,
    type: "inline",
    align: "left",
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  })));
};
const HitTimestamp = ({
  hit
}) => {
  const source = (hit === null || hit === void 0 ? void 0 : hit._source) || {};
  const timestamp = (source === null || source === void 0 ? void 0 : source['@timestamp']) || '-';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CompressedPre, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, timestamp ? (0, _eui.formatDate)(timestamp, 'MMM D, YYYY @ HH:mm:ss.SSS') : '-'));
};
const AgentDataPreview = ({
  dataPreview
}) => {
  const previewData = dataPreview.slice(0, MAX_AGENT_DATA_PREVIEW_COUNT);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, previewData.map(hit => /*#__PURE__*/_react.default.createElement("div", {
    id: hit._id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: '220px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(HitTimestamp, {
    hit: hit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(HitPreview, {
    hit: hit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }))));
};
const ConfirmIncomingDataWithPreview = ({
  agentIds,
  packageInfo,
  agentDataConfirmed,
  setAgentDataConfirmed,
  troubleshootLink
}) => {
  const {
    incomingData,
    dataPreview,
    hasReachedTimeout
  } = (0, _use_get_agent_incoming_data.usePollingIncomingData)({
    agentIds,
    previewData: true,
    stopPollingAfterPreviewLength: MAX_AGENT_DATA_PREVIEW_COUNT
  });
  const {
    numAgentsWithData
  } = (0, _use_get_agent_incoming_data.useGetAgentIncomingData)(incomingData, packageInfo);
  if (!agentDataConfirmed) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "m",
      color: "primary",
      iconType: _eui.EuiLoadingSpinner,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.confirmIncomingDataWithPreview.listening",
        defaultMessage: "Listening for incoming data from enrolled agents...",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 15
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 11
      }
    }), hasReachedTimeout ? /*#__PURE__*/_react.default.createElement(_confirm_incoming_data_timeout.ConfirmIncomingDataTimeout, {
      agentIds: agentIds,
      troubleshootLink: troubleshootLink,
      packageInfo: packageInfo,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.confirmIncomingDataWithPreview.loading",
      defaultMessage: "It might take a few minutes for the data to get to Elasticsearch. If you're not seeing any, try generating some to verify. If you're having trouble connecting, check out the {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          external: true,
          href: troubleshootLink,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 167,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.enrollmentInstructions.troubleshootingLink",
          defaultMessage: "troubleshooting guide",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 168,
            columnNumber: 21
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 10,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "IncomingDataConfirmedCallOut",
    title: _i18n.i18n.translate('xpack.fleet.confirmIncomingDataWithPreview.title', {
      defaultMessage: 'Incoming data received from {numAgentsWithData} enrolled { numAgentsWithData, plural, one {agent} other {agents}}.',
      values: {
        numAgentsWithData
      }
    }),
    color: "success",
    iconType: "check",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.confirmIncomingDataWithPreview.previewTitle",
    defaultMessage: "Preview of incoming data:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(AgentDataPreview, {
    dataPreview: dataPreview,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 7
    }
  }));
};
exports.ConfirmIncomingDataWithPreview = ConfirmIncomingDataWithPreview;