"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyInputVarField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactMarkdown = _interopRequireDefault(require("react-markdown"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _codeEditor = require("@kbn/code-editor");
var _hooks = require("../../../../../../../../hooks");
var _constants = require("../../../../../../../../../common/constants");
var _multi_text_input = require("./multi_text_input");
var _dataset_component = require("./dataset_component");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/components/steps/components/package_policy_input_var_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FixedHeightDiv = _styledComponents.default.div`
  height: 300px;
`;
const FormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  .euiFormRow__label {
    flex: 1;
  }

  .euiFormRow__fieldWrapper > .euiPanel {
    padding: ${props => {
  var _props$theme$eui;
  return (_props$theme$eui = props.theme.eui) === null || _props$theme$eui === void 0 ? void 0 : _props$theme$eui.euiSizeXS;
}};
  }
`;
const PackagePolicyInputVarField = exports.PackagePolicyInputVarField = /*#__PURE__*/(0, _react.memo)(({
  varDef,
  value,
  onChange,
  errors: varErrors,
  forceShowErrors,
  frozen,
  packageType,
  packageName,
  datastreams = [],
  isEditPage = false
}) => {
  const fleetStatus = (0, _hooks.useFleetStatus)();
  const [isDirty, setIsDirty] = (0, _react.useState)(false);
  const {
    required,
    type,
    title,
    name,
    description
  } = varDef;
  const isInvalid = Boolean((isDirty || forceShowErrors) && !!(varErrors !== null && varErrors !== void 0 && varErrors.length));
  const errors = isInvalid ? varErrors : null;
  const fieldLabel = title || name;
  const fieldTestSelector = fieldLabel.replace(/\s/g, '-').toLowerCase();
  // Boolean cannot be optional by default set to false
  const isOptional = (0, _react.useMemo)(() => type !== 'bool' && !required, [required, type]);
  const secretsStorageEnabled = fleetStatus.isReady && fleetStatus.isSecretsStorageEnabled;
  const useSecretsUi = secretsStorageEnabled && varDef.secret;
  if (name === _constants.DATASET_VAR_NAME && packageType === 'input') {
    return /*#__PURE__*/_react.default.createElement(_dataset_component.DatasetComponent, {
      pkgName: packageName,
      datastreams: datastreams,
      value: value,
      onChange: onChange,
      errors: errors,
      isInvalid: isInvalid,
      isDisabled: isEditPage,
      fieldLabel: fieldLabel,
      description: description,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    });
  }
  let field;
  if (useSecretsUi) {
    field = /*#__PURE__*/_react.default.createElement(SecretInputField, {
      varDef: varDef,
      value: value,
      onChange: onChange,
      frozen: frozen,
      packageName: packageName,
      packageType: packageType,
      datastreams: datastreams,
      isEditPage: isEditPage,
      isInvalid: isInvalid,
      fieldLabel: fieldLabel,
      fieldTestSelector: fieldTestSelector,
      isDirty: isDirty,
      setIsDirty: setIsDirty,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 9
      }
    });
  } else {
    field = getInputComponent({
      varDef,
      value,
      onChange,
      frozen,
      isInvalid,
      fieldLabel,
      fieldTestSelector,
      isDirty,
      setIsDirty
    });
  }
  const formRow = /*#__PURE__*/_react.default.createElement(FormRow, {
    isInvalid: isInvalid,
    error: errors,
    hasChildLabel: !varDef.multi,
    label: useSecretsUi ? /*#__PURE__*/_react.default.createElement(SecretFieldLabel, {
      fieldLabel: fieldLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 31
      }
    }) : fieldLabel,
    labelAppend: isOptional ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.inputVarFieldOptionalLabel",
      defaultMessage: "Optional",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 15
      }
    })) : undefined,
    helpText: description && /*#__PURE__*/_react.default.createElement(_reactMarkdown.default, {
      children: description,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 34
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }, field);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, useSecretsUi ? /*#__PURE__*/_react.default.createElement(SecretFieldWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 30
    }
  }, formRow) : formRow);
});
function getInputComponent({
  varDef,
  value,
  onChange,
  frozen,
  isInvalid,
  fieldLabel,
  fieldTestSelector,
  setIsDirty
}) {
  const {
    multi,
    type,
    options,
    full_width: fullWidth
  } = varDef;
  if (multi) {
    return /*#__PURE__*/_react.default.createElement(_multi_text_input.MultiTextInput, {
      fieldLabel: fieldLabel,
      value: value !== null && value !== void 0 ? value : [],
      onChange: onChange,
      onBlur: () => setIsDirty(true),
      isDisabled: frozen,
      "data-test-subj": `multiTextInput-${fieldTestSelector}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 7
      }
    });
  }
  switch (type) {
    case 'textarea':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
        isInvalid: isInvalid,
        value: value === undefined ? '' : value,
        onChange: e => onChange(e.target.value),
        onBlur: () => setIsDirty(true),
        disabled: frozen,
        resize: "vertical",
        fullWidth: fullWidth,
        "data-test-subj": `textAreaInput-${fieldTestSelector}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 9
        }
      });
    case 'yaml':
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, frozen ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        language: "yaml",
        isCopyable: false,
        paddingSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 223,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("pre", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 224,
          columnNumber: 15
        }
      }, value)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FixedHeightDiv, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
        languageId: "yaml",
        width: "100%",
        height: "300px",
        value: value,
        allowFullScreen: true,
        placeholder: _i18n.i18n.translate('xpack.fleet.packagePolicyField.yamlPlaceholder', {
          defaultMessage: 'Enter YAML Configuration'
        }),
        onChange: onChange,
        options: {
          minimap: {
            enabled: false
          },
          ariaLabel: _i18n.i18n.translate('xpack.fleet.packagePolicyField.yamlCodeEditor', {
            defaultMessage: 'YAML Code Editor'
          }),
          scrollBeyondLastLine: false,
          wordWrap: 'off',
          wrappingIndent: 'indent',
          tabSize: 2,
          // To avoid left margin
          lineNumbers: 'off',
          lineNumbersMinChars: 0,
          glyphMargin: false,
          folding: false,
          lineDecorationsWidth: 0,
          overviewRulerBorder: false
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 229,
          columnNumber: 17
        }
      }))));
    case 'bool':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: fieldLabel,
        checked: value,
        showLabel: false,
        onChange: e => onChange(e.target.checked),
        onBlur: () => setIsDirty(true),
        disabled: frozen,
        "data-test-subj": `switch-${fieldTestSelector}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 9
        }
      });
    case 'password':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
        type: "dual",
        isInvalid: isInvalid,
        value: value,
        onChange: e => onChange(e.target.value ? e.target.value : undefined),
        onBlur: () => setIsDirty(true),
        disabled: frozen,
        "data-test-subj": `passwordInput-${fieldTestSelector}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 278,
          columnNumber: 9
        }
      });
    case 'select':
      const selectOptions = options === null || options === void 0 ? void 0 : options.map(option => ({
        value: option.value,
        label: option.text
      }));
      const selectedOptions = value === undefined ? [] : selectOptions === null || selectOptions === void 0 ? void 0 : selectOptions.filter(option => option.value === value);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        placeholder: _i18n.i18n.translate('xpack.fleet.packagePolicyField.selectPlaceholder', {
          defaultMessage: 'Select an option'
        }),
        singleSelection: {
          asPlainText: true
        },
        options: selectOptions,
        selectedOptions: selectedOptions,
        isClearable: true,
        onChange: newSelectedOptions => {
          const newValue = newSelectedOptions.length === 0 ? undefined : newSelectedOptions[0].value;
          return onChange(newValue);
        },
        onBlur: () => setIsDirty(true),
        "data-test-subj": `select-${fieldTestSelector}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 296,
          columnNumber: 9
        }
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        isInvalid: isInvalid,
        value: value,
        onChange: e => onChange(e.target.value ? e.target.value : undefined),
        onBlur: () => setIsDirty(true),
        disabled: frozen,
        "data-test-subj": `textInput-${fieldTestSelector}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 315,
          columnNumber: 9
        }
      });
  }
}
const SecretFieldWrapper = ({
  children
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued",
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 5
    }
  }, children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.fleet.policySecrets,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.secretLearnMoreText",
    defaultMessage: "Learn more about policy secrets.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 11
    }
  }))));
};
const SecretFieldLabel = ({
  fieldLabel
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "aria-label": fieldLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 9
    }
  }, fieldLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "info",
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.createPackagePolicy.stepConfigure.secretLearnMorePopoverContent",
      defaultMessage: "This value is a secret. After you save this integration policy, you won't be able to view the value again.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 360,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 7
    }
  }));
};
function SecretInputField({
  varDef,
  value,
  onChange,
  frozen,
  packageName,
  packageType,
  datastreams = [],
  isEditPage,
  isInvalid,
  fieldLabel,
  fieldTestSelector,
  setIsDirty,
  isDirty
}) {
  var _varDef$title;
  const [isReplacing, setIsReplacing] = (0, _react.useState)(isEditPage && !value);
  const valueOnFirstRender = (0, _react.useRef)(value);
  const hasExistingValue = !!valueOnFirstRender.current;
  const lowercaseTitle = (_varDef$title = varDef.title) === null || _varDef$title === void 0 ? void 0 : _varDef$title.toLowerCase();
  const showInactiveReplaceUi = isEditPage && !isReplacing && hasExistingValue;
  const valueIsSecretRef = value && (value === null || value === void 0 ? void 0 : value.isSecretRef);
  const inputComponent = getInputComponent({
    varDef,
    value: isReplacing && valueIsSecretRef ? '' : value,
    onChange,
    frozen,
    packageName,
    packageType,
    datastreams,
    isEditPage,
    isInvalid,
    fieldLabel,
    fieldTestSelector,
    isDirty,
    setIsDirty
  });

  // If there's no value for this secret, display the input as its "brand new" creation state
  // instead of the "replace" state
  if (!hasExistingValue) {
    return inputComponent;
  }
  if (showInactiveReplaceUi) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 422,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.editPackagePolicy.stepConfigure.fieldSecretValueSet",
      defaultMessage: "The saved {varName} is hidden. You can only replace the {varName}.",
      values: {
        varName: lowercaseTitle
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 423,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 431,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => {
        setIsReplacing(true);
        setIsDirty(false);
        onChange('');
      },
      color: "primary",
      iconType: "refresh",
      iconSide: "left",
      size: "xs",
      "data-test-subj": `button-replace-${fieldTestSelector}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 432,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.editPackagePolicy.stepConfigure.fieldSecretValueSetEditButton",
      defaultMessage: "Replace {varName}",
      values: {
        varName: lowercaseTitle
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 444,
        columnNumber: 11
      }
    })));
  }
  if (isReplacing) {
    const cancelButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => {
        setIsReplacing(false);
        setIsDirty(false);
        onChange(valueOnFirstRender.current);
      },
      color: "primary",
      iconType: "refresh",
      iconSide: "left",
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 458,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.editPackagePolicy.stepConfigure.fieldSecretValueSetCancelButton",
      defaultMessage: "Cancel {varName} change",
      values: {
        varName: lowercaseTitle
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 469,
        columnNumber: 9
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      alignItems: "flexStart",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 479,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        width: '100%'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 480,
        columnNumber: 9
      }
    }, inputComponent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 483,
        columnNumber: 9
      }
    }, cancelButton));
  }
  return inputComponent;
}