"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyIntegrationForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _agent_policy_general_fields = require("./agent_policy_general_fields");
var _agent_policy_system_monitoring_field = require("./agent_policy_system_monitoring_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_integration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AgentPolicyIntegrationForm = ({
  agentPolicy,
  updateAgentPolicy,
  withSysMonitoring,
  updateSysMonitoring,
  validation
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.createAgentPolicyLabel",
      defaultMessage: "Create agent policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.createAgentPolicyDescription",
      defaultMessage: "Add this integration to a new set of hosts by creating a new agent policy. You can add agent in the next step.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_policy_general_fields.AgentPolicyGeneralFields, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    validation: validation,
    nameLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.newAgentPolicyFieldLabel",
      defaultMessage: "New agent policy name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_agent_policy_system_monitoring_field.AgentPolicyFormSystemMonitoringCheckbox, {
    withSysMonitoring: withSysMonitoring,
    updateSysMonitoring: updateSysMonitoring,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  })));
};
exports.AgentPolicyIntegrationForm = AgentPolicyIntegrationForm;