"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpViewActionMenuContent = ExpViewActionMenuContent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _embed_action = require("../../header/embed_action");
var _add_to_case_action = require("../../header/add_to_case_action");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/components/action_menu/action_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ExpViewActionMenuContent({
  timeRange,
  lensAttributes
}) {
  const {
    lens,
    isDev
  } = (0, _use_kibana.useKibana)().services;
  const [isSaveOpen, setIsSaveOpen] = (0, _react.useState)(false);
  const LensSaveModalComponent = lens.SaveModalComponent;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    style: {
      paddingRight: 20
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, isDev && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_embed_action.EmbedAction, {
    lensAttributes: lensAttributes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 13
    }
  })), timeRange && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_add_to_case_action.AddToCaseAction, {
    lensAttributes: lensAttributes,
    timeRange: timeRange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yExpViewActionMenuContentOpenInLensButton",
    iconType: "lensApp",
    fullWidth: false,
    isDisabled: !lens.canUseEditor() || lensAttributes === null,
    size: "s",
    onClick: () => {
      if (lensAttributes) {
        lens.navigateToPrefilledEditor({
          id: '',
          timeRange,
          attributes: lensAttributes
        }, {
          openInNewTab: true
        });
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.exploratoryView.expView.heading.openInLens', {
    defaultMessage: 'Open in Lens'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yExpViewActionMenuContentSaveButton",
    fill: true,
    iconType: "save",
    fullWidth: false,
    isDisabled: !lens.canUseEditor() || lensAttributes === null,
    onClick: () => {
      if (lensAttributes) {
        setIsSaveOpen(true);
      }
    },
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.exploratoryView.expView.heading.saveLensVisualization', {
    defaultMessage: 'Save'
  })))), isSaveOpen && lensAttributes && /*#__PURE__*/_react.default.createElement(LensSaveModalComponent, {
    initialInput: {
      attributes: lensAttributes
    },
    onClose: () => setIsSaveOpen(false)
    // if we want to do anything after the viz is saved
    // right now there is no action, so an empty function
    ,
    onSave: () => {},
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }));
}