"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apiPublishesESQLVariables = exports.apiPublishesESQLVariable = exports.VariableNamePrefix = exports.EsqlControlType = exports.ESQLVariableType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let VariableNamePrefix = exports.VariableNamePrefix = /*#__PURE__*/function (VariableNamePrefix) {
  VariableNamePrefix["IDENTIFIER"] = "??";
  VariableNamePrefix["VALUE"] = "?";
  return VariableNamePrefix;
}({});
let ESQLVariableType = exports.ESQLVariableType = /*#__PURE__*/function (ESQLVariableType) {
  ESQLVariableType["TIME_LITERAL"] = "time_literal";
  ESQLVariableType["FIELDS"] = "fields";
  ESQLVariableType["VALUES"] = "values";
  ESQLVariableType["FUNCTIONS"] = "functions";
  return ESQLVariableType;
}({});
/**
 * Types of ES|QL controls
 * - STATIC_VALUES: Static values that are not dependent on any query
 * - VALUES_FROM_QUERY: Values that are dependent on an ES|QL query
 */
let EsqlControlType = exports.EsqlControlType = /*#__PURE__*/function (EsqlControlType) {
  EsqlControlType["STATIC_VALUES"] = "STATIC_VALUES";
  EsqlControlType["VALUES_FROM_QUERY"] = "VALUES_FROM_QUERY";
  return EsqlControlType;
}({});
const apiPublishesESQLVariable = unknownApi => {
  return Boolean(unknownApi && (unknownApi === null || unknownApi === void 0 ? void 0 : unknownApi.esqlVariable$) !== undefined);
};
exports.apiPublishesESQLVariable = apiPublishesESQLVariable;
const apiPublishesESQLVariables = unknownApi => {
  return Boolean(unknownApi && (unknownApi === null || unknownApi === void 0 ? void 0 : unknownApi.esqlVariables$) !== undefined);
};
exports.apiPublishesESQLVariables = apiPublishesESQLVariables;