"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTypes = FieldTypes;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _addonActions = require("@storybook/addon-actions");
var _eui = require("@elastic/eui");
var _components = require("../../../components");
var _helpers = require("../../../helpers");
var _use_field = require("../use_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/es_ui_shared/static/forms/hook_form_lib/components/__stories__/use_field_field_types.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const fieldTypeOptions = ['checkBox', 'comboBox', 'jsonEditor', 'multiSelect', 'number', 'radioGroup', 'range', 'select', 'superSelect', 'text', 'textArea', 'toggle'];
const fieldConfigBase = {
  label: 'My field'
};
const getPropsForType = type => {
  switch (type) {
    case 'text':
      return {
        component: _components.TextField
      };
    case 'number':
      return {
        component: _components.NumericField,
        config: {
          ...fieldConfigBase,
          formatters: [_helpers.fieldFormatters.toInt]
        }
      };
    case 'toggle':
      return {
        component: _components.ToggleField,
        defaultValue: true
      };
    case 'checkBox':
      return {
        component: _components.CheckBoxField,
        defaultValue: true
      };
    case 'select':
      return {
        component: _components.SelectField,
        defaultValue: 'option_one',
        componentProps: {
          euiFieldProps: {
            options: [{
              value: 'option_one',
              text: 'Option one'
            }, {
              value: 'option_two',
              text: 'Option two'
            }, {
              value: 'option_three',
              text: 'Option three'
            }]
          }
        }
      };
    case 'superSelect':
      return {
        component: _components.SuperSelectField,
        defaultValue: 'minor',
        componentProps: {
          euiFieldProps: {
            options: [{
              value: 'warning',
              inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
                color: "subdued",
                css: {
                  lineHeight: 'inherit'
                },
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 101,
                  columnNumber: 19
                }
              }, "Warning"),
              disabled: true
            }, {
              value: 'minor',
              inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
                color: "warning",
                css: {
                  lineHeight: 'inherit'
                },
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 110,
                  columnNumber: 19
                }
              }, "Minor")
            }, {
              value: 'critical',
              inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
                color: "danger",
                css: {
                  lineHeight: 'inherit'
                },
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 118,
                  columnNumber: 19
                }
              }, "Critical")
            }]
          }
        }
      };
    case 'multiSelect':
      // TODO: update MultiSelectField to use <EuiFilterGroup>
      // and <EuiPopOver>
      return {
        component: _components.MultiSelectField,
        euiFieldProps: {
          options: [{
            label: 'Johann Sebastian Bach',
            checked: 'on'
          }, {
            label: 'Wolfgang Amadeus Mozart',
            checked: 'on'
          }, {
            label: 'Antonín Dvořák',
            checked: 'off'
          }, {
            label: 'Dmitri Shostakovich'
          }, {
            label: 'Felix Mendelssohn-Bartholdy'
          }, {
            label: 'Franz Liszt'
          }, {
            label: 'Franz Schubert'
          }, {
            label: 'Frédéric Chopin'
          }, {
            label: 'Georg Friedrich Händel'
          }, {
            label: 'Giuseppe Verdi'
          }, {
            label: 'Gustav Mahler'
          }, {
            label: 'Igor Stravinsky'
          }, {
            label: 'Johannes Brahms'
          }, {
            label: 'Joseph Haydn'
          }, {
            label: 'Ludwig van Beethoven'
          }, {
            label: 'Piotr Illitch Tchaïkovsky'
          }, {
            label: 'Robert Schumann'
          }, {
            label: 'Sergej S. Prokofiew'
          }],
          searchable: true
        }
      };
    case 'comboBox':
      return {
        component: _components.ComboBoxField,
        defaultValue: []
      };
    case 'jsonEditor':
      return {
        component: _components.JsonEditorField,
        defaultValue: '',
        componentProps: {
          euiCodeEditorProps: {
            height: '280px'
          }
        }
      };
    case 'radioGroup':
      return {
        component: _components.RadioGroupField,
        defaultValue: 'optionTwo',
        euiFieldProps: {
          options: [{
            id: 'optionOne',
            label: 'Option one'
          }, {
            id: 'optionTwo',
            label: 'Option two is checked by default'
          }, {
            id: 'radioGroupItemThird',
            label: 'Option three is disabled',
            disabled: true
          }]
        }
      };
    case 'textArea':
      return {
        component: _components.TextAreaField
      };
    case 'range':
      return {
        component: _components.RangeField,
        defaultValue: 3,
        config: {
          ...fieldConfigBase,
          serializer: _helpers.fieldFormatters.toInt
        }
      };
    default:
      throw new Error(`No props found for ${type} type`);
  }
};
function FieldTypes({
  fieldType
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  }, "Info: change the field type in the \"Controls\" panel below."))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_use_field.UseField, (0, _extends2.default)({
    // We add a key to force a reset of the state whenever
    // the field type changes
    key: fieldType,
    path: "myField",
    config: {
      ...fieldConfigBase
    },
    onChange: (0, _addonActions.action)('onChange')
  }, getPropsForType(fieldType), {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 7
    }
  })));
}
FieldTypes.args = {
  fieldType: 'text'
};
FieldTypes.argTypes = {
  fieldType: {
    options: fieldTypeOptions,
    control: {
      type: 'radio'
    }
  }
};
FieldTypes.storyName = 'FieldTypes';
FieldTypes.parameters = {
  docs: {
    source: {
      code: `
const MyFormComponent = () => {
  const { form } = useForm({ defaultValue });

  const submitForm = async () => {
    const { isValid, data } = await form.submit();
    if (isValid) {
      // ... do something with the data
    }
  };

  return (
    <Form form={form}>
      <EuiText>
        <p>
          <EuiTextColor color="subdued">
            Info: change the field type in the &quot;Controls&quot; panel below.
          </EuiTextColor>
        </p>
      </EuiText>
      <EuiSpacer />
      <UseField<any>
        // We add a key to force a reset of the state whenever
        // the field type changes
        key={fieldType}
        path="myField"
        config={{ ...fieldConfigBase }}
        onChange={action('onChange')}
        {...getPropsForType(fieldType)}
      />
      <EuiSpacer />
      <EuiButton onClick={submitForm}>Send</EuiButton>
    </Form>
  );
};
      `,
      language: 'tsx'
    }
  }
};