"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActiveContexts = useActiveContexts;
var _react = require("react");
var _record_has_context = require("../profiles_manager/record_has_context");
var _types = require("../../application/types");
var _scoped_services_provider = require("../../components/scoped_services_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function useActiveContexts({
  dataDocuments$
}) {
  const {
    scopedProfilesManager
  } = (0, _scoped_services_provider.useScopedServices)();
  const getContextsAdapter = (0, _react.useCallback)(({
    onOpenDocDetails
  }) => {
    const {
      dataSourceContext,
      rootContext
    } = scopedProfilesManager.getContexts();
    return {
      getRootContext: () => rootContext,
      getDataSourceContext: () => dataSourceContext,
      getDocumentContexts: () => {
        var _data$result;
        const data = dataDocuments$.getValue();
        if (data.fetchStatus !== _types.FetchStatus.COMPLETE) {
          return {};
        }
        const documents = (_data$result = data.result) !== null && _data$result !== void 0 ? _data$result : [];
        const documentContexts = {};
        for (const record of documents) {
          if (!(0, _record_has_context.recordHasContext)(record)) continue;
          const contextProfileId = record.context.profileId;
          if (!documentContexts[contextProfileId]) {
            documentContexts[contextProfileId] = [];
          }
          documentContexts[contextProfileId].push(record);
        }
        return documentContexts;
      },
      openDocDetails: onOpenDocDetails
    };
  }, [scopedProfilesManager, dataDocuments$]);
  return getContextsAdapter;
}