"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverTopNav = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/data-views-plugin/public");
var _public2 = require("@kbn/controls-plugin/public");
var _discoverUtils = require("@kbn/discover-utils");
var _react2 = require("@emotion/react");
var _constants = require("../../../../../common/constants");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _customizations = require("../../../../customizations");
var _discover_app_state_container = require("../../state_management/discover_app_state_container");
var _use_discover_topnav = require("./use_discover_topnav");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
var _use_esql_variables = require("./use_esql_variables");
var _esql_dataview_transition = require("./esql_dataview_transition");
var _redux = require("../../state_management/redux");
var _save_discover_session = require("./save_discover_session");
var _discover_topnav_menu = require("./discover_topnav_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/top_nav/discover_topnav.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DiscoverTopNav = ({
  savedQuery,
  stateContainer,
  esqlModeErrors,
  esqlModeWarning,
  onFieldEdited,
  isLoading,
  onCancelClick
}) => {
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    dataViewEditor,
    navigation,
    dataViewFieldEditor,
    data
  } = services;
  const [controlGroupApi, setControlGroupApi] = (0, _react.useState)();
  const query = (0, _discover_app_state_container.useAppStateSelector)(state => state.query);
  const esqlVariables = (0, _redux.useCurrentTabSelector)(tab => tab.esqlVariables);
  const timeRange = (0, _redux.useCurrentTabSelector)(tab => tab.dataRequestParams.timeRangeAbsolute);
  const {
    savedDataViews,
    adHocDataViews
  } = (0, _redux.useDataViewsForPicker)();
  const dataView = (0, _redux.useCurrentDataView)();
  const isESQLToDataViewTransitionModalVisible = (0, _redux.useInternalStateSelector)(state => state.isESQLToDataViewTransitionModalVisible);
  const tabsEnabled = services.discoverFeatureFlags.getTabsEnabled();
  const persistedDiscoverSession = (0, _redux.useInternalStateSelector)(state => state.persistedDiscoverSession);
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const showDatePicker = (0, _react.useMemo)(() => {
    // always show the timepicker for ES|QL mode
    return isEsqlMode || !isEsqlMode && dataView.isTimeBased() && dataView.type !== _public.DataViewType.ROLLUP;
  }, [dataView, isEsqlMode]);
  const closeFieldEditor = (0, _react.useRef)();

  // ES|QL controls logic
  const {
    onSaveControl,
    getActivePanels
  } = (0, _use_esql_variables.useESQLVariables)({
    isEsqlMode,
    stateContainer,
    currentEsqlVariables: esqlVariables,
    controlGroupApi,
    onUpdateESQLQuery: stateContainer.actions.updateESQLQuery
  });
  (0, _react.useEffect)(() => {
    return () => {
      // Make sure to close the editors when unmounting
      if (closeFieldEditor.current) {
        closeFieldEditor.current();
      }
    };
  }, []);
  const canEditDataView = Boolean(dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.userPermissions.editDataView()) || !dataView.isPersisted();
  const editField = (0, _react.useMemo)(() => canEditDataView ? async fieldName => {
    if (dataView !== null && dataView !== void 0 && dataView.id) {
      const dataViewInstance = await data.dataViews.get(dataView.id);
      const editedDataView = await (0, _discoverUtils.prepareDataViewForEditing)(dataViewInstance, data.dataViews);
      closeFieldEditor.current = await dataViewFieldEditor.openEditor({
        ctx: {
          dataView: editedDataView
        },
        fieldName,
        onSave: async () => {
          await onFieldEdited({
            editedDataView
          });
        }
      });
    }
  } : undefined, [canEditDataView, dataView === null || dataView === void 0 ? void 0 : dataView.id, data.dataViews, dataViewFieldEditor, onFieldEdited]);
  const addField = (0, _react.useMemo)(() => canEditDataView && editField ? () => editField() : undefined, [editField, canEditDataView]);
  const updateSavedQueryId = newSavedQueryId => {
    const {
      appState
    } = stateContainer;
    if (newSavedQueryId) {
      appState.update({
        savedQuery: newSavedQueryId
      });
    } else {
      // remove savedQueryId from state
      const newState = {
        ...appState.getState()
      };
      delete newState.savedQuery;
      appState.set(newState);
    }
  };
  const onESQLToDataViewTransitionModalClose = (0, _react.useCallback)((shouldDismissModal, needsSave) => {
    if (shouldDismissModal) {
      services.storage.set(_constants.ESQL_TRANSITION_MODAL_KEY, true);
    }
    dispatch(_redux.internalStateActions.setIsESQLToDataViewTransitionModalVisible(false));
    // the user dismissed the modal, we don't need to save the search or switch to the data view mode
    if (needsSave == null) {
      return;
    }
    if (needsSave) {
      (0, _save_discover_session.onSaveDiscoverSession)({
        services,
        state: stateContainer,
        onClose: () => dispatch(_redux.internalStateActions.setIsESQLToDataViewTransitionModalVisible(false)),
        onSaveCb: () => {
          var _dataView$id;
          stateContainer.actions.transitionFromESQLToDataView((_dataView$id = dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : '');
        }
      });
    } else {
      var _dataView$id2;
      stateContainer.actions.transitionFromESQLToDataView((_dataView$id2 = dataView.id) !== null && _dataView$id2 !== void 0 ? _dataView$id2 : '');
    }
  }, [dataView.id, dispatch, services, stateContainer]);
  const {
    topNavBadges,
    topNavMenu
  } = (0, _use_discover_topnav.useDiscoverTopNav)({
    stateContainer,
    persistedDiscoverSession
  });
  const dataViewPickerProps = (0, _react.useMemo)(() => {
    return {
      trigger: {
        label: (dataView === null || dataView === void 0 ? void 0 : dataView.getName()) || '',
        'data-test-subj': 'discover-dataView-switch-link',
        title: (dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern()) || ''
      },
      currentDataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
      onAddField: addField,
      onDataViewCreated: stateContainer.actions.onDataViewCreated,
      onCreateDefaultAdHocDataView: stateContainer.actions.createAndAppendAdHocDataView,
      onChangeDataView: stateContainer.actions.onChangeDataView,
      adHocDataViews,
      savedDataViews,
      onEditDataView: stateContainer.actions.onDataViewEdited
    };
  }, [adHocDataViews, addField, dataView, savedDataViews, stateContainer]);
  const onESQLDocsFlyoutVisibilityChanged = (0, _react.useCallback)(isOpen => {
    if (isOpen) {
      (0, _discoverUtils.dismissAllFlyoutsExceptFor)(_discoverUtils.DiscoverFlyouts.esqlDocs);
    }
  }, []);
  const searchBarCustomization = (0, _customizations.useDiscoverCustomization)('search_bar');
  const SearchBar = (0, _react.useMemo)(() => {
    var _searchBarCustomizati;
    return (_searchBarCustomizati = searchBarCustomization === null || searchBarCustomization === void 0 ? void 0 : searchBarCustomization.CustomSearchBar) !== null && _searchBarCustomizati !== void 0 ? _searchBarCustomizati : navigation.ui.AggregateQueryTopNavMenu;
  }, [searchBarCustomization === null || searchBarCustomization === void 0 ? void 0 : searchBarCustomization.CustomSearchBar, navigation.ui.AggregateQueryTopNavMenu]);
  const searchDraftUiState = (0, _redux.useCurrentTabSelector)(state => state.uiState.searchDraft);
  const setSearchDraftUiState = (0, _redux.useCurrentTabAction)(_redux.internalStateActions.setSearchDraftUiState);
  const onSearchDraftChange = (0, _react.useCallback)(newSearchDraftUiState => {
    dispatch(setSearchDraftUiState({
      searchDraftUiState: newSearchDraftUiState
    }));
  }, [dispatch, setSearchDraftUiState]);
  const esqlEditorUiState = (0, _redux.useCurrentTabSelector)(state => state.uiState.esqlEditor);
  const setEsqlEditorUiState = (0, _redux.useCurrentTabAction)(_redux.internalStateActions.setESQLEditorUiState);
  const onEsqlEditorInitialStateChange = (0, _react.useCallback)(newEsqlEditorUiState => {
    dispatch(setEsqlEditorUiState({
      esqlEditorUiState: newEsqlEditorUiState
    }));
  }, [dispatch, setEsqlEditorUiState]);
  const shouldHideDefaultDataviewPicker = !!(searchBarCustomization !== null && searchBarCustomization !== void 0 && searchBarCustomization.CustomDataViewPicker) || !!(searchBarCustomization !== null && searchBarCustomization !== void 0 && searchBarCustomization.hideDataViewPicker);
  return /*#__PURE__*/_react.default.createElement("span", {
    css: floatingActionStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_discover_topnav_menu.DiscoverTopNavMenu, {
    topNavBadges: topNavBadges,
    topNavMenu: topNavMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(SearchBar, {
    useBackgroundSearchButton: stateContainer.customizationContext.displayMode !== 'embedded' && services.data.search.isBackgroundSearchEnabled && !!services.capabilities.discover_v2.storeSearchSession,
    appName: "discover",
    indexPatterns: [dataView],
    onQuerySubmit: stateContainer.actions.onUpdateQuery,
    onCancel: onCancelClick,
    isLoading: isLoading,
    onSavedQueryIdChange: updateSavedQueryId,
    query: query,
    savedQueryId: savedQuery,
    screenTitle: persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.title,
    showDatePicker: showDatePicker,
    allowSavingQueries: true,
    showSearchBar: true,
    useDefaultBehaviors: true,
    dataViewPickerOverride: searchBarCustomization !== null && searchBarCustomization !== void 0 && searchBarCustomization.CustomDataViewPicker ? /*#__PURE__*/_react.default.createElement(searchBarCustomization.CustomDataViewPicker, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 13
      }
    }) : undefined,
    dataViewPickerComponentProps: shouldHideDefaultDataviewPicker ? undefined : dataViewPickerProps,
    displayStyle: "detached",
    textBasedLanguageModeErrors: esqlModeErrors ? [esqlModeErrors] : undefined,
    textBasedLanguageModeWarning: esqlModeWarning,
    prependFilterBar: searchBarCustomization !== null && searchBarCustomization !== void 0 && searchBarCustomization.PrependFilterBar ? /*#__PURE__*/_react.default.createElement(searchBarCustomization.PrependFilterBar, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 13
      }
    }) : undefined,
    onESQLDocsFlyoutVisibilityChanged: onESQLDocsFlyoutVisibilityChanged,
    draft: searchDraftUiState,
    onDraftChange: tabsEnabled ? onSearchDraftChange : undefined,
    esqlEditorInitialState: esqlEditorUiState,
    onEsqlEditorInitialStateChange: onEsqlEditorInitialStateChange,
    esqlVariablesConfig: isEsqlMode ? {
      esqlVariables: esqlVariables !== null && esqlVariables !== void 0 ? esqlVariables : [],
      onSaveControl,
      controlsWrapper: /*#__PURE__*/_react.default.createElement(_public2.ControlGroupRenderer, {
        onApiAvailable: setControlGroupApi,
        timeRange: timeRange,
        getCreationOptions: async initialState => {
          var _ref, _getActivePanels;
          const initialChildControlState = (_ref = (_getActivePanels = getActivePanels()) !== null && _getActivePanels !== void 0 ? _getActivePanels : initialState.initialChildControlState) !== null && _ref !== void 0 ? _ref : {};
          return {
            initialState: {
              ...initialState,
              initialChildControlState
            }
          };
        },
        viewMode: "edit",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 300,
          columnNumber: 19
        }
      })
    } : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 7
    }
  }), isESQLToDataViewTransitionModalVisible && /*#__PURE__*/_react.default.createElement(_esql_dataview_transition.ESQLToDataViewTransitionModal, {
    onClose: onESQLToDataViewTransitionModalClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 9
    }
  }));
};

// ToDo: Remove when the new layout lands https://github.com/elastic/kibana/issues/234854
exports.DiscoverTopNav = DiscoverTopNav;
const floatingActionStyles = (0, _react2.css)({
  '.controlFrameFloatingActions': {
    top: '100%',
    transform: 'translate(0, -20%)',
    left: '-8px',
    right: 'auto'
  }
});