"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AbstractExploreDataAction = exports.ACTION_EXPLORE_DATA = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/lens-plugin/common/constants");
var _presentationPublishing = require("@kbn/presentation-publishing");
var shared = _interopRequireWildcard(require("./shared"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTION_EXPLORE_DATA = exports.ACTION_EXPLORE_DATA = 'ACTION_EXPLORE_DATA';
const isApiCompatible = api => (0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.apiHasType)(api) && (0, _presentationPublishing.apiPublishesDataViews)(api);
const compatibilityCheck = api => {
  return isApiCompatible(api) && (0, _presentationPublishing.getInheritedViewMode)(api) === 'view' && !(0, _presentationPublishing.apiIsOfType)(api, _constants.DOC_TYPE);
};
class AbstractExploreDataAction {
  constructor(params) {
    (0, _defineProperty2.default)(this, "getIconType", () => 'discoverApp');
    (0, _defineProperty2.default)(this, "getDisplayName", () => _i18n.i18n.translate('xpack.discover.FlyoutCreateDrilldownAction.displayName', {
      defaultMessage: 'Explore underlying data'
    }));
    this.params = params;
  }
  async getLocation({
    embeddable
  }, eventParams) {
    var _parentParams$filters, _childParams$filters, _eventParams$filters, _parentParams$query, _ref, _eventParams$timeRang;
    const {
      plugins
    } = this.params.start();
    const {
      locator
    } = plugins.discover;
    if (!locator) {
      throw new Error('Discover URL locator not available.');
    }
    const parentParams = {};
    if ((0, _presentationPublishing.apiHasParentApi)(embeddable) && (0, _presentationPublishing.apiPublishesPartialUnifiedSearch)(embeddable.parentApi)) {
      var _embeddable$parentApi, _embeddable$parentApi2, _embeddable$parentApi3, _embeddable$parentApi4;
      parentParams.filters = (_embeddable$parentApi = (_embeddable$parentApi2 = embeddable.parentApi.filters$) === null || _embeddable$parentApi2 === void 0 ? void 0 : _embeddable$parentApi2.getValue()) !== null && _embeddable$parentApi !== void 0 ? _embeddable$parentApi : [];
      parentParams.query = (_embeddable$parentApi3 = embeddable.parentApi.query$) === null || _embeddable$parentApi3 === void 0 ? void 0 : _embeddable$parentApi3.getValue();
      parentParams.timeRange = (_embeddable$parentApi4 = embeddable.parentApi.timeRange$) === null || _embeddable$parentApi4 === void 0 ? void 0 : _embeddable$parentApi4.getValue();
    }
    const childParams = {};
    if ((0, _presentationPublishing.apiPublishesPartialUnifiedSearch)(embeddable)) {
      var _embeddable$filters$$, _embeddable$filters$, _embeddable$query$, _embeddable$timeRange;
      childParams.filters = (_embeddable$filters$$ = (_embeddable$filters$ = embeddable.filters$) === null || _embeddable$filters$ === void 0 ? void 0 : _embeddable$filters$.getValue()) !== null && _embeddable$filters$$ !== void 0 ? _embeddable$filters$$ : [];
      childParams.query = (_embeddable$query$ = embeddable.query$) === null || _embeddable$query$ === void 0 ? void 0 : _embeddable$query$.getValue();
      childParams.timeRange = (_embeddable$timeRange = embeddable.timeRange$) === null || _embeddable$timeRange === void 0 ? void 0 : _embeddable$timeRange.getValue();
    }
    const params = {
      dataViewId: shared.getDataViews(embeddable)[0],
      filters: [
      // combine filters from all possible sources
      ...((_parentParams$filters = parentParams.filters) !== null && _parentParams$filters !== void 0 ? _parentParams$filters : []), ...((_childParams$filters = childParams.filters) !== null && _childParams$filters !== void 0 ? _childParams$filters : []), ...((_eventParams$filters = eventParams === null || eventParams === void 0 ? void 0 : eventParams.filters) !== null && _eventParams$filters !== void 0 ? _eventParams$filters : [])],
      query: (_parentParams$query = parentParams.query) !== null && _parentParams$query !== void 0 ? _parentParams$query : childParams.query,
      // overwrite the child query with the parent query
      // prioritize event time range for chart action; otherwise, overwrite the parent time range with the child's
      timeRange: (_ref = (_eventParams$timeRang = eventParams === null || eventParams === void 0 ? void 0 : eventParams.timeRange) !== null && _eventParams$timeRang !== void 0 ? _eventParams$timeRang : childParams.timeRange) !== null && _ref !== void 0 ? _ref : parentParams.timeRange
    };
    const location = await locator.getLocation(params);
    return location;
  }
  async isCompatible({
    embeddable
  }) {
    if (!compatibilityCheck(embeddable)) return false;
    const {
      core,
      plugins
    } = this.params.start();
    const {
      capabilities
    } = core.application;
    if (capabilities.discover_v2 && !capabilities.discover_v2.show) return false;
    if (!plugins.discover.locator) return false;
    return shared.hasExactlyOneDataView(embeddable);
  }
  async execute(api) {
    const {
      embeddable
    } = api;
    if (!this.isCompatible({
      embeddable
    })) return;
    const {
      core
    } = this.params.start();
    const {
      app,
      path
    } = await this.getLocation(api);
    await core.application.navigateToApp(app, {
      path
    });
  }
  async getHref(api) {
    const {
      embeddable
    } = api;
    if (!this.isCompatible({
      embeddable
    })) {
      throw new Error(`Embeddable not supported for "${this.getDisplayName()}" action.`);
    }
    const {
      core
    } = this.params.start();
    const {
      app,
      path
    } = await this.getLocation(api);
    const url = core.application.getUrlForApp(app, {
      path,
      absolute: false
    });
    return url;
  }
}
exports.AbstractExploreDataAction = AbstractExploreDataAction;