"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DocumentTrends;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _unifiedHistogram = require("@kbn/unified-histogram");
var _react = _interopRequireWildcard(require("react"));
var _translations = require("../../../../../common/translations");
var _hooks = require("../../../../hooks");
var _trend_docs_chart = require("./trend_docs_chart");
var _use_kibana = require("../../../../utils/use_kibana");
var _get_alerting_capabilities = require("../../../../alerts/get_alerting_capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/overview/document_trends/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function DocumentTrends({
  lastReloadTime,
  openAlertFlyout,
  displayActions: {
    displayCreateRuleButton,
    displayEditFailureStore
  }
}) {
  const {
    timeRange,
    updateTimeRange
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const {
    dataView,
    breakdown,
    redirectLinkProps,
    handleDocsTrendChartChange,
    ...qualityIssuesChartProps
  } = (0, _hooks.useQualityIssuesDocsChart)();
  const {
    trackDatasetDetailsBreakdownFieldChanged
  } = (0, _hooks.useDatasetDetailsTelemetry)();
  const {
    services: {
      application,
      alerting
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    capabilities
  } = application;
  const {
    isAlertingAvailable
  } = (0, _get_alerting_capabilities.getAlertingCapabilities)(alerting, capabilities);
  const onTimeRangeChange = (0, _react.useCallback)(({
    start,
    end
  }) => {
    updateTimeRange({
      start,
      end
    });
  }, [updateTimeRange]);
  const onBreakdownFieldChange = (0, _react.useCallback)(breakdownField => {
    trackDatasetDetailsBreakdownFieldChanged();
    breakdown.onChange(breakdownField);
  }, [breakdown, trackDatasetDetailsBreakdownFieldChanged]);
  const {
    openModal: openFailureStoreModal,
    canUserManageFailureStore,
    renderModal: renderFailureStoreModal
  } = (0, _hooks.useFailureStoreModal)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "stretch",
    justifyContent: "spaceBetween",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: 160,
    height: 32,
    isLoading: !dataView,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_unifiedHistogram.UnifiedBreakdownFieldSelector, {
    dataView: dataView,
    breakdown: {
      field: breakdown.dataViewField && breakdown.fieldSupportsBreakdown ? breakdown.dataViewField : undefined
    },
    onBreakdownFieldChange: onBreakdownFieldChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.openInDiscoverText,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    display: "base",
    iconType: "discoverApp",
    "aria-label": _translations.discoverAriaText,
    size: "s",
    "data-test-subj": "datasetQualityDetailsLinkToDiscover"
  }, redirectLinkProps.linkProps, {
    color: "text",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }))), displayCreateRuleButton && isAlertingAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.createAlertText,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    iconType: "bell",
    "aria-label": _translations.createAlertText,
    size: "s",
    "data-test-subj": "datasetQualityDetailsCreateRule",
    onClick: openAlertFlyout,
    color: "text",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 17
    }
  })), displayEditFailureStore && canUserManageFailureStore && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.editFailureStoreText,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    iconType: "pencil",
    "aria-label": _translations.editFailureStoreText,
    size: "s",
    "data-test-subj": "datasetQualityDetailsEditFailureStore",
    onClick: openFailureStoreModal,
    color: "text",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_trend_docs_chart.TrendDocsChart, (0, _extends2.default)({}, qualityIssuesChartProps, {
    timeRange: timeRange,
    lastReloadTime: lastReloadTime,
    onTimeRangeChange: onTimeRangeChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  })), renderFailureStoreModal());
}
module.exports = exports.default;