"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableFieldStatsUserInput = EmbeddableFieldStatsUserInput;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _field_stats_initializer = require("./field_stats_initializer");
var _get_data_view_by_index_pattern = require("../../search_strategy/requests/get_data_view_by_index_pattern");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/index_data_visualizer/embeddables/field_stats/field_stats_embeddable_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EmbeddableFieldStatsUserInput({
  coreStart,
  pluginStart,
  isNewPanel,
  initialState,
  fieldStatsControlsApi,
  closeFlyout,
  onUpdate
}) {
  const hasChanged = _react.default.useRef(false);
  const cancelChanges = () => {
    // Reset to initialState in case user has changed the preview state
    if (hasChanged.current && fieldStatsControlsApi && initialState) {
      fieldStatsControlsApi.updateUserInput(initialState);
    }
    closeFlyout();
  };
  const update = async nextUpdate => {
    var _nextUpdate$query;
    const esqlQuery = nextUpdate === null || nextUpdate === void 0 ? void 0 : (_nextUpdate$query = nextUpdate.query) === null || _nextUpdate$query === void 0 ? void 0 : _nextUpdate$query.esql;
    if ((0, _mlIsDefined.isDefined)(esqlQuery)) {
      const dv = await (0, _get_data_view_by_index_pattern.getOrCreateDataViewByIndexPattern)(pluginStart.data.dataViews, esqlQuery, undefined);
      if (dv !== null && dv !== void 0 && dv.id && nextUpdate.dataViewId !== dv.id) {
        nextUpdate.dataViewId = dv.id;
      }
    }
    onUpdate(nextUpdate);
    closeFlyout();
  };
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      ...pluginStart
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_field_stats_initializer.FieldStatisticsInitializer, {
    initialInput: initialState,
    onPreview: async nextUpdate => {
      if (fieldStatsControlsApi) {
        fieldStatsControlsApi.updateUserInput(nextUpdate);
        hasChanged.current = true;
      }
    },
    onCreate: update,
    onCancel: cancelChanges,
    isNewPanel: isNewPanel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }));
}