"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BooleanContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _i18nReact = require("@kbn/i18n-react");
var _mlNumberUtils = require("@kbn/ml-number-utils");
var _i18n = require("@kbn/i18n");
var _top_values = require("../../../top_values");
var _utils = require("../../utils");
var _hooks = require("../../hooks");
var _expanded_row_field_header = require("../expanded_row_field_header");
var _document_stats = require("./document_stats");
var _expanded_row_content = require("./expanded_row_content");
var _expanded_row_panel = require("./expanded_row_panel");
var _use_bar_color = require("./use_bar_color");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/stats_table/components/field_data_expanded_row/boolean_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getPercentLabel(value) {
  if (value === 0) {
    return '0%';
  }
  if (value >= 0.1) {
    return `${(0, _mlNumberUtils.roundToDecimalPlace)(value)}%`;
  } else {
    return '< 0.1%';
  }
}
function getFormattedValue(value, totalCount) {
  const percentage = value / totalCount * 100;
  return `${value} (${getPercentLabel(percentage)})`;
}
const BOOLEAN_DISTRIBUTION_CHART_HEIGHT = 70;
const BooleanContent = ({
  config,
  onAddFilter
}) => {
  const barColor = (0, _use_bar_color.useBarColor)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const fieldFormat = 'fieldFormat' in config ? config.fieldFormat : undefined;
  const formattedPercentages = (0, _react.useMemo)(() => (0, _utils.getTFPercentage)(config), [config]);
  const theme = (0, _hooks.useDataVizChartTheme)({
    disableGridLines: true
  });
  if (!formattedPercentages) return null;
  const {
    count
  } = formattedPercentages;
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerBooleanContent',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_top_values.TopValues, {
    stats: config.stats,
    fieldFormat: fieldFormat,
    barColor: barColor,
    onAddFilter: onAddFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    className: 'dvPanel__wrapper dvPanel--uniform',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_expanded_row_field_header.ExpandedRowFieldHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.field.cardBoolean.valuesLabel",
    defaultMessage: "Values",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    renderer: "canvas",
    size: {
      height: BOOLEAN_DISTRIBUTION_CHART_HEIGHT
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: "bottom",
    showOverlappingTicks: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left2",
    title: "Left axis",
    hide: true,
    tickFormat: d => getFormattedValue(d, count),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartBaseTheme,
    showLegend: false,
    theme: theme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: config.fieldName || fieldFormat,
    data: [{
      x: 'true',
      count: formattedPercentages.trueCount
    }, {
      x: 'false',
      count: formattedPercentages.falseCount
    }],
    splitSeriesAccessors: ['x'],
    stackAccessors: ['x'],
    xAccessor: "x",
    xScaleType: _charts.ScaleType.Ordinal,
    yAccessors: ['count'],
    yScaleType: _charts.ScaleType.Linear,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }))));
};
exports.BooleanContent = BooleanContent;