"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CombinedFieldsReadOnlyForm = CombinedFieldsReadOnlyForm;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _combined_field_label = require("./combined_field_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/combined_fields/combined_fields_read_only_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CombinedFieldsReadOnlyForm({
  combinedFields
}) {
  return combinedFields.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.dataVisualizer.combinedFieldsReadOnlyLabel', {
      defaultMessage: 'Combined fields'
    }),
    helpText: _i18n.i18n.translate('xpack.dataVisualizer.combinedFieldsReadOnlyHelpTextLabel', {
      defaultMessage: 'Edit combined fields in advanced tab'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, combinedFields.map((combinedField, idx) => /*#__PURE__*/_react.default.createElement(_combined_field_label.CombinedFieldLabel, {
    key: idx,
    combinedField: combinedField,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 11
    }
  })))) : null;
}