"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoData = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable2 = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _sharedUxPageAnalyticsNoData = require("@kbn/shared-ux-page-analytics-no-data");
var _add_data_prompt = require("../add_data_prompt");
var _empty_index_list_prompt = require("../empty_index_list_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/index_pattern_table/no_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * @internal
 */

const NoDataServerlessSearch = ({
  uiSettings,
  http,
  docLinks
}) => {
  var _useObservable;
  const {
    hasApiKeys,
    error,
    isLoading
  } = (_useObservable = (0, _useObservable2.default)((0, _react.useMemo)(() => (0, _sharedUxPageAnalyticsNoData.getHasApiKeys$)(http), [http]))) !== null && _useObservable !== void 0 ? _useObservable : {};
  if (error) {
    throw error;
  }
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 12
      }
    });
  }
  const addDataHref = hasApiKeys ? uiSettings.get('defaultRoute') + '#ingestData' : uiSettings.get('defaultRoute');
  return /*#__PURE__*/_react.default.createElement(_add_data_prompt.AddDataPrompt, {
    addDataHref: addDataHref,
    docLink: docLinks.links.indexPatterns.introduction,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  });
};

/**
 * @internal
 */
const NoData = ({
  noDataPage,
  docLinks,
  http,
  uiSettings,
  application,
  dataViewController,
  setShowCreateDialog
}) => {
  var _noDataPage$getAnalyt;
  const flavor = (_noDataPage$getAnalyt = noDataPage === null || noDataPage === void 0 ? void 0 : noDataPage.getAnalyticsNoDataPageFlavor()) !== null && _noDataPage$getAnalyt !== void 0 ? _noDataPage$getAnalyt : 'kibana';
  switch (flavor) {
    case 'serverless_search':
      {
        return /*#__PURE__*/_react.default.createElement(NoDataServerlessSearch, {
          http: http,
          uiSettings: uiSettings,
          docLinks: docLinks,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 78,
            columnNumber: 14
          }
        });
      }
    default:
      return /*#__PURE__*/_react.default.createElement(_empty_index_list_prompt.EmptyIndexListPrompt, {
        onRefresh: dataViewController.loadDataViews,
        createAnyway: () => setShowCreateDialog(true),
        canSaveIndexPattern: !!application.capabilities.indexPatterns.save,
        navigateToApp: application.navigateToApp,
        addDataUrl: docLinks.links.indexPatterns.introduction,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 9
        }
      });
  }
};
exports.NoData = NoData;