"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_DASHBOARD_URL = exports.PRINT_DASHBOARD_URL = exports.GLOBAL_STATE_STORAGE_KEY = exports.DASHBOARD_STATE_STORAGE_KEY = exports.CREATE_NEW_DASHBOARD_URL = void 0;
exports.createDashboardEditUrl = createDashboardEditUrl;
exports.createDashboardListingFilterUrl = createDashboardListingFilterUrl;
exports.getFullPath = exports.getFullEditPath = void 0;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DASHBOARD_STATE_STORAGE_KEY = exports.DASHBOARD_STATE_STORAGE_KEY = '_a';
const GLOBAL_STATE_STORAGE_KEY = exports.GLOBAL_STATE_STORAGE_KEY = '_g';
const CREATE_NEW_DASHBOARD_URL = exports.CREATE_NEW_DASHBOARD_URL = '/create';
const VIEW_DASHBOARD_URL = exports.VIEW_DASHBOARD_URL = '/view';
const PRINT_DASHBOARD_URL = exports.PRINT_DASHBOARD_URL = '/print';
const getFullPath = (aliasId, id) => `/app/dashboards#${createDashboardEditUrl(aliasId || id)}`;
exports.getFullPath = getFullPath;
const getFullEditPath = (id, editMode) => {
  return `/app/dashboards#${createDashboardEditUrl(id, editMode)}`;
};
exports.getFullEditPath = getFullEditPath;
function createDashboardEditUrl(id, editMode) {
  if (!id) {
    return `${CREATE_NEW_DASHBOARD_URL}`;
  }
  const edit = editMode ? `?${DASHBOARD_STATE_STORAGE_KEY}=(viewMode:edit)` : '';
  return `${VIEW_DASHBOARD_URL}/${id}${edit}`;
}
function createDashboardListingFilterUrl(filter) {
  return filter ? `${_constants.LANDING_PAGE_PATH}?filter="${filter}"` : _constants.LANDING_PAGE_PATH;
}