"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DashboardListing = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _contentManagementFavoritesPublic = require("@kbn/content-management-favorites-public");
var _contentManagementTableListView = require("@kbn/content-management-table-list-view");
var _contentManagementTableListViewTable = require("@kbn/content-management-table-list-view-table");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../common/constants");
var _telemetry_constants = require("../utils/telemetry_constants");
var _kibana_services = require("../services/kibana_services");
var _dashboard_query_client = require("../services/dashboard_query_client");
var _dashboard_unsaved_listing = require("./dashboard_unsaved_listing");
var _use_dashboard_listing_table = require("./hooks/use_dashboard_listing_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_listing/dashboard_listing.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardListing = ({
  children,
  initialFilter,
  goToDashboard,
  getDashboardUrl,
  useSessionStorageIntegration
}) => {
  (0, _public.useExecutionContext)(_kibana_services.coreServices.executionContext, {
    type: 'application',
    page: 'list'
  });
  const {
    unsavedDashboardIds,
    refreshUnsavedDashboards,
    tableListViewTableProps,
    contentInsightsClient
  } = (0, _use_dashboard_listing_table.useDashboardListingTable)({
    goToDashboard,
    getDashboardUrl,
    useSessionStorageIntegration,
    initialFilter
  });
  const dashboardFavoritesClient = (0, _react.useMemo)(() => {
    return new _contentManagementFavoritesPublic.FavoritesClient(_constants.DASHBOARD_APP_ID, _telemetry_constants.DASHBOARD_CONTENT_ID, {
      http: _kibana_services.coreServices.http,
      usageCollection: _kibana_services.usageCollectionService,
      userProfile: _kibana_services.coreServices.userProfile
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: _dashboard_query_client.dashboardQueryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_contentManagementTableListViewTable.TableListViewKibanaProvider, {
    core: _kibana_services.coreServices,
    savedObjectsTagging: _kibana_services.savedObjectsTaggingService === null || _kibana_services.savedObjectsTaggingService === void 0 ? void 0 : _kibana_services.savedObjectsTaggingService.getTaggingApi(),
    FormattedRelative: _i18nReact.FormattedRelative,
    favorites: dashboardFavoritesClient,
    contentInsightsClient,
    isKibanaVersioningEnabled: !_kibana_services.serverlessService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_contentManagementTableListView.TableListView, (0, _extends2.default)({}, tableListViewTableProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, /*#__PURE__*/_react.default.createElement(_dashboard_unsaved_listing.DashboardUnsavedListing, {
    goToDashboard: goToDashboard,
    unsavedDashboardIds: unsavedDashboardIds,
    refreshUnsavedDashboards: refreshUnsavedDashboards,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }))))));
};

// eslint-disable-next-line import/no-default-export
exports.DashboardListing = DashboardListing;
var _default = exports.default = DashboardListing;