"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DraggableBodyRows = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/shared/tables/reorderable_table/draggable_body_rows.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DraggableBodyRows = ({
  items,
  onReorder,
  renderItem
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    role: "rowgroup",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: ({
      source,
      destination
    }) => {
      if (source && destination) {
        const reorderedItems = (0, _eui.euiDragDropReorder)(items, source.index, destination === null || destination === void 0 ? void 0 : destination.index);
        onReorder(reorderedItems, items);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "ReorderingArea",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items.map(renderItem)))));
};
exports.DraggableBodyRows = DraggableBodyRows;