"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RunFromSourceStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _dedent = _interopRequireDefault(require("dedent"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchApiPanels = require("@kbn/search-api-panels");
var _constants = require("../../search_index/connector/constants");
var _cloud_details = require("../../shared/cloud_details/cloud_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connector_detail/components/run_from_source_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RunFromSourceStep = ({
  apiKeyData,
  connectorId,
  isWaitingForConnector,
  serviceType,
  connectorVersion
}) => {
  const [isOpen, setIsOpen] = _react.default.useState('open');
  (0, _react.useEffect)(() => {
    if (!isWaitingForConnector) {
      setIsOpen('closed');
    }
  }, [isWaitingForConnector]);
  const {
    elasticsearchUrl
  } = (0, _cloud_details.useCloudDetails)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "runFromSourceAccordion",
    onToggle: () => setIsOpen(isOpen === 'closed' ? 'open' : 'closed'),
    forceState: isOpen,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.runFromSourceTitle', {
      defaultMessage: 'Run connector service from source'
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.cloneRepositoryLabel', {
    defaultMessage: 'Clone the repository'
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.addTheFollowingConfigurationLabel', {
    defaultMessage: 'First, you need to clone or download the repo:'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, "git clone https://github.com/elastic/connectors"), "\xA0\xA0\xA0", _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.orLabel', {
    defaultMessage: 'or'
  }), "\xA0\xA0\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchConnectorDeploymentGoToSourceButton",
    iconType: "logoGithub",
    href: "https://github.com/elastic/connectors",
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.goToSourceButtonLabel', {
    defaultMessage: 'Download source'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.createConfigFileLabel', {
    defaultMessage: 'Create configuration file'
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.navigateToRootLabel', {
    defaultMessage: 'Navigate to the root of your cloned repository and create a configuration file:'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    showTopBar: false,
    languageType: "bash",
    codeSnippet: `cd connectors && git checkout ${connectorVersion} && touch config.yml`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.populateConfigLabel', {
    defaultMessage: 'Populate configuration file'
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.contentConnectors..connectorDeployment.p.createConfigLabel",
    defaultMessage: "The previous command creates a {configYaml} file. Copy and paste the following configuration into that file:",
    values: {
      configYaml: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.configYamlCodeBlockLabel', {
        defaultMessage: 'config.yml'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    showTopBar: false,
    languageType: "yaml",
    codeSnippet: (0, _constants.getConnectorTemplate)({
      apiKeyData,
      connectorData: {
        id: connectorId !== null && connectorId !== void 0 ? connectorId : '',
        service_type: serviceType
      },
      host: elasticsearchUrl
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.contentConnectors..connectorDeployment.customizeSettingsLabel",
    defaultMessage: "If you want to customize settings later, refer to this {exampleFile}.",
    values: {
      exampleFile: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "enterpriseSearchRunFromSourceStepExampleFileLink",
        href: "https://github.com/elastic/connectors/blob/main/config.yml.example",
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.exampleConfigFileLinkLabel', {
        defaultMessage: 'example file'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.compileAndRunTitle', {
    defaultMessage: 'Run the connector service'
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.p.compileAndRunInstructions', {
    defaultMessage: 'Finally, compile and run the connector service source code:'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    showTopBar: false,
    languageType: "bash",
    codeSnippet: (0, _dedent.default)`
                              make install
                              make run
                              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  })));
};
exports.RunFromSourceStep = RunFromSourceStep;