"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistoryViewer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _monaco = require("@kbn/monaco");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _utils = require("../../../lib/utils");
var _hooks = require("../editor/hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/containers/history/history_viewer_monaco.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HistoryViewer = ({
  settings,
  req
}) => {
  const divRef = (0, _react.useRef)(null);
  const {
    setupResizeChecker,
    destroyResizeChecker
  } = (0, _hooks.useResizeCheckerUtils)();
  const editorDidMountCallback = (0, _react.useCallback)(editor => {
    setupResizeChecker(divRef.current, editor);
  }, [setupResizeChecker]);
  const editorWillUnmountCallback = (0, _react.useCallback)(() => {
    destroyResizeChecker();
  }, [destroyResizeChecker]);
  let renderedHistoryRequest;
  if (req) {
    const indent = true;
    const formattedData = req.data ? (0, _utils.formatRequestBodyDoc)([req.data], indent).data : '';
    renderedHistoryRequest = req.method + ' ' + req.endpoint + '\n' + formattedData;
  } else {
    renderedHistoryRequest = _i18n.i18n.translate('console.historyPage.monaco.noHistoryTextMessage', {
      defaultMessage: '# No history available to display'
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        width: 100%;
        height: 100%;
      `,
    ref: divRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: _codeEditor.CONSOLE_LANG_ID,
    value: renderedHistoryRequest,
    fullWidth: true,
    editorDidMount: editorDidMountCallback,
    editorWillUnmount: editorWillUnmountCallback,
    options: {
      readOnly: true,
      fontSize: settings.fontSize,
      wordWrap: settings.wrapMode ? 'on' : 'off',
      theme: _monaco.CONSOLE_THEME_ID,
      automaticLayout: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }));
};
exports.HistoryViewer = HistoryViewer;