"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindingsDistributionBar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/configurations/layout/findings_distribution_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const I18N_PASSED_FINDINGS = _i18n.i18n.translate('xpack.csp.findings.distributionBar.totalPassedLabel', {
  defaultMessage: 'Passed Findings'
});
const I18N_FAILED_FINDINGS = _i18n.i18n.translate('xpack.csp.findings.distributionBar.totalFailedLabel', {
  defaultMessage: 'Failed Findings'
});
const I18N_PASSED_FINDINGS_FILTER_LABEL = _i18n.i18n.translate('xpack.csp.findings.distributionBar.passedFilterLabel', {
  defaultMessage: 'Filter for passed findings'
});
const I18N_FAILED_FINDINGS_FILTER_LABEL = _i18n.i18n.translate('xpack.csp.findings.distributionBar.failedFilterLabel', {
  defaultMessage: 'Filter for failed findings'
});
const FindingsDistributionBar = props => /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(Counters, (0, _extends2.default)({}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 5
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(DistributionBar, (0, _extends2.default)({}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 48,
    columnNumber: 5
  }
})));
exports.FindingsDistributionBar = FindingsDistributionBar;
const Counters = ({
  passed,
  failed
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    getMisconfigurationStatusColor
  } = (0, _cloudSecurityPosture.useGetMisconfigurationStatusColor)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    css: (0, _react2.css)`
        gap: ${euiTheme.size.m};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: getMisconfigurationStatusColor(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.PASSED),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, I18N_PASSED_FINDINGS), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, (0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(passed)), /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: getMisconfigurationStatusColor(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.FAILED),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, I18N_FAILED_FINDINGS), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, (0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(failed)));
};
const DistributionBar = ({
  passed,
  failed,
  distributionOnClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    getMisconfigurationStatusColor
  } = (0, _cloudSecurityPosture.useGetMisconfigurationStatusColor)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: (0, _react2.css)`
        height: 8px;
        background: ${euiTheme.colors.lightestShade};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(DistributionBarPart, {
    value: passed,
    color: getMisconfigurationStatusColor(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.PASSED),
    distributionOnClick: () => {
      distributionOnClick(_constants.RULE_PASSED);
    },
    "data-test-subj": "distribution_bar_passed",
    "aria-label": `${I18N_PASSED_FINDINGS_FILTER_LABEL}. ${I18N_PASSED_FINDINGS}: ${passed}`,
    title: `${I18N_PASSED_FINDINGS_FILTER_LABEL}. ${I18N_PASSED_FINDINGS}: ${passed}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(DistributionBarPart, {
    value: failed,
    color: getMisconfigurationStatusColor(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.FAILED),
    distributionOnClick: () => {
      distributionOnClick(_constants.RULE_FAILED);
    },
    "data-test-subj": "distribution_bar_failed",
    "aria-label": `${I18N_FAILED_FINDINGS_FILTER_LABEL}. ${I18N_FAILED_FINDINGS}: ${failed}`,
    title: `${I18N_FAILED_FINDINGS_FILTER_LABEL}. ${I18N_FAILED_FINDINGS}: ${failed}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }));
};
const DistributionBarPart = ({
  value,
  color,
  distributionOnClick,
  ...rest
}) => /*#__PURE__*/_react.default.createElement("button", {
  "data-test-subj": rest['data-test-subj'],
  "aria-label": rest['aria-label'],
  title: rest.title,
  onClick: distributionOnClick,
  css: {
    background: color,
    height: '100%'
  },
  style: {
    flex: value
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 127,
    columnNumber: 3
  }
});