"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowAlertTableLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../common/types");
var _navigation = require("../../../common/navigation");
var _translations = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/comment/show_alert_table_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ShowAlertTableLink = () => {
  const {
    navigateToCaseView
  } = (0, _navigation.useCaseViewNavigation)();
  const {
    detailName
  } = (0, _navigation.useCaseViewParams)();
  const handleShowAlertsTable = (0, _react.useCallback)(() => {
    navigateToCaseView({
      detailName,
      tabId: _types.CASE_VIEW_PAGE_TABS.ALERTS
    });
  }, [navigateToCaseView, detailName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 41
      }
    }, _translations.SHOW_ALERT_TABLE_TOOLTIP),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translations.SHOW_ALERT_TABLE_TOOLTIP,
    "data-test-subj": `comment-action-show-alerts-${detailName}`,
    onClick: handleShowAlertsTable,
    iconType: "inspect",
    id: `${detailName}-show-alerts`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }));
};
exports.ShowAlertTableLink = ShowAlertTableLink;
ShowAlertTableLink.displayName = 'ShowAlertTableLink';