"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertTemplateCustomFields = void 0;
exports.removeEmptyFields = removeEmptyFields;
exports.templateSerializer = exports.templateDeserializer = void 0;
var _lodash = require("lodash");
var _utils = require("../configure_cases/utils");
var _utils2 = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function removeEmptyFields(obj) {
  return Object.fromEntries(Object.entries(obj).filter(([_, value]) => !(0, _lodash.isEmpty)(value) || typeof value === 'boolean').map(([key, value]) => [key, value === Object(value) && !Array.isArray(value) ? removeEmptyFields(value) : value]));
}
const convertTemplateCustomFields = customFields => {
  if (!customFields || !customFields.length) {
    return null;
  }
  return customFields.reduce((acc, customField) => {
    const initial = {
      [customField.key]: customField.value
    };
    return {
      ...acc,
      ...initial
    };
  }, {});
};
exports.convertTemplateCustomFields = convertTemplateCustomFields;
const templateDeserializer = data => {
  var _connector$fields, _connector$id, _connectorFields$fiel;
  if (data == null) {
    return data;
  }
  const {
    key,
    name,
    description,
    tags: templateTags,
    caseFields
  } = data;
  const {
    connector,
    customFields,
    settings,
    tags,
    ...rest
  } = caseFields !== null && caseFields !== void 0 ? caseFields : {};
  const connectorFields = (0, _utils2.getConnectorsFormDeserializer)({
    fields: (_connector$fields = connector === null || connector === void 0 ? void 0 : connector.fields) !== null && _connector$fields !== void 0 ? _connector$fields : null
  });
  const convertedCustomFields = (0, _utils2.customFieldsFormDeserializer)(customFields);
  return {
    key,
    name,
    templateDescription: description !== null && description !== void 0 ? description : '',
    templateTags: templateTags !== null && templateTags !== void 0 ? templateTags : [],
    connectorId: (_connector$id = connector === null || connector === void 0 ? void 0 : connector.id) !== null && _connector$id !== void 0 ? _connector$id : 'none',
    fields: (_connectorFields$fiel = connectorFields.fields) !== null && _connectorFields$fiel !== void 0 ? _connectorFields$fiel : null,
    customFields: convertedCustomFields !== null && convertedCustomFields !== void 0 ? convertedCustomFields : {},
    tags: tags !== null && tags !== void 0 ? tags : [],
    ...rest
  };
};
exports.templateDeserializer = templateDeserializer;
const templateSerializer = (connectors, currentConfiguration, data) => {
  if (data == null) {
    return data;
  }
  const {
    fields: connectorFields = null,
    key,
    name,
    customFields: templateCustomFields,
    ...rest
  } = data;
  const serializedConnectorFields = (0, _utils2.getConnectorsFormSerializer)({
    fields: connectorFields
  });
  const nonEmptyFields = removeEmptyFields({
    ...rest
  });
  const {
    connectorId,
    syncAlerts = false,
    extractObservables = false,
    templateTags,
    templateDescription,
    ...otherCaseFields
  } = nonEmptyFields;
  const transformedCustomFields = templateCustomFields ? (0, _utils2.customFieldsFormSerializer)(templateCustomFields, currentConfiguration.customFields) : [];
  const templateConnector = connectorId ? (0, _utils2.getConnectorById)(connectorId, connectors) : null;
  const transformedConnector = templateConnector ? (0, _utils.normalizeActionConnector)(templateConnector, serializedConnectorFields.fields) : (0, _utils.getNoneConnector)();
  const transformedData = {
    key,
    name,
    description: templateDescription,
    tags: templateTags !== null && templateTags !== void 0 ? templateTags : [],
    caseFields: {
      ...otherCaseFields,
      connector: transformedConnector,
      customFields: transformedCustomFields,
      settings: {
        syncAlerts,
        extractObservables
      }
    }
  };
  return transformedData;
};
exports.templateSerializer = templateSerializer;