"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormFieldsWithFormContext = exports.CreateCaseForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _description = require("../case_form_fields/description");
var i18n = _interopRequireWildcard(require("./translations"));
var _timeline_context = require("../timeline_context");
var _insert_timeline = require("../insert_timeline");
var _utils = require("../utils");
var _utils2 = require("../markdown_editor/utils");
var _submit_button = require("./submit_button");
var _form_context = require("./form_context");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_cancel_creation_action = require("./use_cancel_creation_action");
var _cancel_creation_confirmation_modal = require("./cancel_creation_confirmation_modal");
var _use_get_supported_action_connectors = require("../../containers/configure/use_get_supported_action_connectors");
var _use_get_all_case_configurations = require("../../containers/configure/use_get_all_case_configurations");
var _form_fields = require("./form_fields");
var _utils3 = require("../../containers/configure/utils");
var _owner_selector = require("./owner_selector");
var _use_available_owners = require("../app/use_available_owners");
var _utils4 = require("./utils");
var _use_cases_features = require("../../common/use_cases_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/create/form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FormFieldsWithFormContext = exports.FormFieldsWithFormContext = /*#__PURE__*/_react.default.memo(({
  currentConfiguration,
  isLoadingCaseConfiguration,
  withSteps,
  draftStorageKey,
  selectedOwner,
  onSelectedOwner
}) => {
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const availableOwners = (0, _use_available_owners.useAvailableCasesOwners)();
  const shouldShowOwnerSelector = Boolean(!owner.length && availableOwners.length > 1);
  const {
    reset
  } = (0, _hook_form_lib.useFormContext)();
  const {
    data: connectors = [],
    isLoading: isLoadingConnectors
  } = (0, _use_get_supported_action_connectors.useGetSupportedActionConnectors)();
  const onOwnerChange = (0, _react.useCallback)(newOwner => {
    onSelectedOwner(newOwner);
    reset({
      resetValues: true,
      defaultValue: (0, _utils4.getInitialCaseValue)({
        owner: newOwner,
        connector: currentConfiguration.connector
      })
    });
  }, [currentConfiguration.connector, onSelectedOwner, reset]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldShowOwnerSelector && /*#__PURE__*/_react.default.createElement(_owner_selector.CreateCaseOwnerSelector, {
    selectedOwner: selectedOwner,
    availableOwners: availableOwners,
    isLoading: isLoadingCaseConfiguration,
    onOwnerChange: onOwnerChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_form_fields.CreateCaseFormFields, {
    connectors: connectors,
    isLoading: isLoadingConnectors || isLoadingCaseConfiguration,
    withSteps: withSteps,
    draftStorageKey: draftStorageKey,
    configuration: currentConfiguration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }));
});
FormFieldsWithFormContext.displayName = 'FormFieldsWithFormContext';
const CreateCaseForm = exports.CreateCaseForm = /*#__PURE__*/_react.default.memo(({
  withSteps = true,
  afterCaseCreated,
  onCancel,
  onSuccess,
  timelineIntegration,
  attachments,
  observables = [],
  initialValue
}) => {
  var _owner$;
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const availableOwners = (0, _use_available_owners.useAvailableCasesOwners)();
  const defaultOwnerValue = (_owner$ = owner[0]) !== null && _owner$ !== void 0 ? _owner$ : (0, _utils4.getOwnerDefaultValue)(availableOwners);
  const [selectedOwner, onSelectedOwner] = (0, _react.useState)(defaultOwnerValue);
  const {
    observablesAuthorized,
    isExtractObservablesEnabled,
    isObservablesFeatureEnabled
  } = (0, _use_cases_features.useCasesFeatures)();
  const canExtractObservables = observablesAuthorized && isObservablesFeatureEnabled && isExtractObservablesEnabled;
  const {
    data: configurations,
    isLoading: isLoadingCaseConfiguration
  } = (0, _use_get_all_case_configurations.useGetAllCaseConfigurations)();
  const draftStorageKey = (0, _utils2.getMarkdownEditorStorageKey)({
    appId: owner[0],
    caseId: 'createCase',
    commentId: 'description'
  });
  const handleOnConfirmationCallback = () => {
    onCancel();
    (0, _utils.removeItemFromSessionStorage)(draftStorageKey);
  };
  const {
    showConfirmationModal,
    onOpenModal,
    onConfirmModal,
    onCancelModal
  } = (0, _use_cancel_creation_action.useCancelCreationAction)({
    onConfirmationCallback: handleOnConfirmationCallback
  });
  const handleOnSuccess = theCase => {
    (0, _utils.removeItemFromSessionStorage)(draftStorageKey);
    return onSuccess(theCase);
  };
  const currentConfiguration = (0, _react.useMemo)(() => (0, _utils3.getConfigurationByOwner)({
    configurations,
    owner: selectedOwner
  }), [configurations, selectedOwner]);
  return /*#__PURE__*/_react.default.createElement(_timeline_context.CasesTimelineIntegrationProvider, {
    timelineIntegration: timelineIntegration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_form_context.FormContext, {
    afterCaseCreated: afterCaseCreated,
    onSuccess: handleOnSuccess,
    attachments: attachments,
    initialValue: initialValue,
    currentConfiguration: currentConfiguration,
    selectedOwner: selectedOwner,
    observables: canExtractObservables ? observables : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(FormFieldsWithFormContext, {
    withSteps: withSteps,
    draftStorageKey: draftStorageKey,
    selectedOwner: selectedOwner,
    onSelectedOwner: onSelectedOwner,
    isLoadingCaseConfiguration: isLoadingCaseConfiguration,
    currentConfiguration: currentConfiguration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "l",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "create-case-cancel",
    iconType: "cross",
    onClick: onOpenModal,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 17
    }
  }, i18n.CANCEL), showConfirmationModal && /*#__PURE__*/_react.default.createElement(_cancel_creation_confirmation_modal.CancelCreationConfirmationModal, {
    title: i18n.MODAL_TITLE,
    onConfirm: onConfirmModal,
    onCancel: onCancelModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_submit_button.SubmitCaseButton, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_insert_timeline.InsertTimeline, {
    fieldName: _description.fieldName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  })));
});
CreateCaseForm.displayName = 'CreateCaseForm';