"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmTraceErrorQuery = getApmTraceErrorQuery;
exports.requiredFields = exports.optionalFields = void 0;
var _server = require("@kbn/observability-plugin/server");
var _as_mutable_array = require("../../../common/utils/as_mutable_array");
var _document_type = require("../../../common/document_type");
var _rollup = require("../../../common/rollup");
var _apm = require("../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const requiredFields = exports.requiredFields = (0, _as_mutable_array.asMutableArray)([_apm.TIMESTAMP_US, _apm.TRACE_ID, _apm.SERVICE_NAME, _apm.ERROR_ID, _apm.ERROR_GROUP_ID, _apm.PROCESSOR_EVENT, _apm.ID]);
const optionalFields = exports.optionalFields = (0, _as_mutable_array.asMutableArray)([_apm.PARENT_ID, _apm.TRANSACTION_ID, _apm.SPAN_ID, _apm.SPAN_DESTINATION_SERVICE_RESOURCE, _apm.ERROR_CULPRIT, _apm.ERROR_LOG_MESSAGE, _apm.ERROR_EXC_MESSAGE, _apm.ERROR_EXC_HANDLED, _apm.ERROR_EXC_TYPE]);
const excludedLogLevels = ['debug', 'info', 'warning'];
function getApmTraceErrorQuery({
  apmEventClient,
  traceId,
  docId,
  start,
  end
}) {
  return apmEventClient.search('get_errors_docs', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.ErrorEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    track_total_hits: false,
    size: 1000,
    query: {
      bool: {
        filter: [...(0, _server.termQuery)(_apm.TRACE_ID, traceId), ...(0, _server.termQuery)(_apm.SPAN_ID, docId), ...(0, _server.rangeQuery)(start, end)],
        must_not: {
          terms: {
            [_apm.ERROR_LOG_LEVEL]: excludedLogLevels
          }
        }
      }
    },
    fields: [...requiredFields, ...optionalFields],
    _source: [_apm.ERROR_LOG_MESSAGE, _apm.ERROR_EXC_MESSAGE, _apm.ERROR_EXC_HANDLED, _apm.ERROR_EXC_TYPE]
  });
}