"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnvironmentBadge = EnvironmentBadge;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _item_badge = require("../item_badge");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/environment_badge/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EnvironmentBadge({
  environments = []
}) {
  if (environments.length === 0) {
    environments.push((0, _environment_filter_values.getEnvironmentLabel)(_environment_filter_values.ENVIRONMENT_NOT_DEFINED_VALUE));
  }
  return /*#__PURE__*/_react.default.createElement(_item_badge.ItemsBadge, {
    items: environments,
    multipleItemsMessage: _i18n.i18n.translate('xpack.apm.servicesTable.environmentCount', {
      values: {
        environmentCount: environments.length
      },
      defaultMessage: '{environmentCount, plural, one {1 environment} other {# environments}}'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  });
}