"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsList = StatsList;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _managed_table = require("../../../../../shared/managed_table");
var _get_columns = require("./get_columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/transaction_overview/transaction_overview_tabs/stats_list/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function StatsList({
  isLoading,
  mainStatistics,
  detailedStatisticsLoading,
  detailedStatistics,
  comparisonEnabled,
  offset
}) {
  const columns = (0, _react.useMemo)(() => {
    return (0, _get_columns.getColumns)({
      detailedStatisticsLoading,
      detailedStatistics,
      comparisonEnabled,
      offset
    });
  }, [detailedStatisticsLoading, detailedStatistics, comparisonEnabled, offset]);
  return /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    noItemsMessage: isLoading ? _i18n.i18n.translate('xpack.apm.mobile.stats.table.loading', {
      defaultMessage: 'Loading...'
    }) : _i18n.i18n.translate('xpack.apm.mobile.stats.table.noDataMessage', {
      defaultMessage: 'No data found'
    }),
    items: mainStatistics,
    columns: columns,
    sortItems: false,
    initialPageSize: 25,
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  });
}