"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileStats = MobileStats;
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n2 = require("../../../../../../common/i18n");
var _use_apm_params = require("../../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _metric_item = require("./metric_item");
var _use_previous_period_text = require("../../../../../hooks/use_previous_period_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/service_overview/stats/stats.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const valueFormatter = (value, suffix = '') => {
  return `${value} ${suffix}`;
};
function MobileStats({
  start,
  end,
  kuery
}) {
  var _data$currentPeriod$c, _data$currentPeriod, _data$currentPeriod$c2, _data$currentPeriod$c3, _data$currentPeriod2, _data$currentPeriod2$, _data$previousPeriod$, _data$currentPeriod$l, _data$currentPeriod3, _data$currentPeriod3$, _data$currentPeriod$l2, _data$currentPeriod4, _data$currentPeriod4$, _data$previousPeriod$2, _data$currentPeriod$s, _data$currentPeriod5, _data$currentPeriod5$, _data$currentPeriod$s2, _data$currentPeriod6, _data$currentPeriod6$, _data$previousPeriod$3, _data$previousPeriod$4, _data$currentPeriod$r, _data$currentPeriod7, _data$currentPeriod7$, _data$currentPeriod$r2, _data$currentPeriod8, _data$currentPeriod8$;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    path: {
      serviceName
    },
    query: {
      environment,
      transactionType,
      offset,
      comparisonEnabled
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/mobile-services/{serviceName}/overview');
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/mobile-services/{serviceName}/stats', {
      params: {
        path: {
          serviceName
        },
        query: {
          start,
          end,
          environment,
          kuery,
          transactionType,
          offset
        }
      }
    });
  }, [start, end, environment, kuery, serviceName, transactionType, offset]);
  const getComparisonValueFormatter = (0, _react.useCallback)(value => {
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }, value && comparisonEnabled ? `${previousPeriodLabel}: ${Number.isInteger(value) ? value : value.toFixed(2)}` : null);
  }, [comparisonEnabled, previousPeriodLabel]);
  const getIcon = (0, _react.useCallback)(type => ({
    width = 20,
    height = 20,
    color
  }) => {
    return status === _use_fetcher.FETCH_STATUS.LOADING ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: type,
      width: width,
      height: height,
      fill: color,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    });
  }, [status]);
  const loadingStats = (0, _use_fetcher.isPending)(status);
  const metrics = [{
    color: euiTheme.colors.lightestShade,
    title: _i18n.i18n.translate('xpack.apm.mobile.metrics.crash.rate', {
      defaultMessage: 'Crash rate'
    }),
    icon: getIcon('bug'),
    value: (_data$currentPeriod$c = data === null || data === void 0 ? void 0 : (_data$currentPeriod = data.currentPeriod) === null || _data$currentPeriod === void 0 ? void 0 : (_data$currentPeriod$c2 = _data$currentPeriod.crashRate) === null || _data$currentPeriod$c2 === void 0 ? void 0 : _data$currentPeriod$c2.value) !== null && _data$currentPeriod$c !== void 0 ? _data$currentPeriod$c : NaN,
    valueFormatter: value => Number.isNaN(value) ? _i18n2.NOT_AVAILABLE_LABEL : valueFormatter(Number((value * 100).toPrecision(2)), '%'),
    trend: (_data$currentPeriod$c3 = data === null || data === void 0 ? void 0 : (_data$currentPeriod2 = data.currentPeriod) === null || _data$currentPeriod2 === void 0 ? void 0 : (_data$currentPeriod2$ = _data$currentPeriod2.crashRate) === null || _data$currentPeriod2$ === void 0 ? void 0 : _data$currentPeriod2$.timeseries) !== null && _data$currentPeriod$c3 !== void 0 ? _data$currentPeriod$c3 : [],
    extra: getComparisonValueFormatter(data === null || data === void 0 ? void 0 : (_data$previousPeriod$ = data.previousPeriod.crashRate) === null || _data$previousPeriod$ === void 0 ? void 0 : _data$previousPeriod$.value),
    trendShape: _charts.MetricTrendShape.Area
  }, {
    color: euiTheme.colors.lightestShade,
    title: _i18n.i18n.translate('xpack.apm.mobile.metrics.load.time', {
      defaultMessage: 'Average app load time'
    }),
    icon: getIcon('visGauge'),
    value: (_data$currentPeriod$l = data === null || data === void 0 ? void 0 : (_data$currentPeriod3 = data.currentPeriod) === null || _data$currentPeriod3 === void 0 ? void 0 : (_data$currentPeriod3$ = _data$currentPeriod3.launchTimes) === null || _data$currentPeriod3$ === void 0 ? void 0 : _data$currentPeriod3$.value) !== null && _data$currentPeriod$l !== void 0 ? _data$currentPeriod$l : NaN,
    valueFormatter: value => Number.isNaN(value) ? _i18n2.NOT_AVAILABLE_LABEL : valueFormatter(Number(value.toFixed(1)), 'ms'),
    trend: (_data$currentPeriod$l2 = data === null || data === void 0 ? void 0 : (_data$currentPeriod4 = data.currentPeriod) === null || _data$currentPeriod4 === void 0 ? void 0 : (_data$currentPeriod4$ = _data$currentPeriod4.launchTimes) === null || _data$currentPeriod4$ === void 0 ? void 0 : _data$currentPeriod4$.timeseries) !== null && _data$currentPeriod$l2 !== void 0 ? _data$currentPeriod$l2 : [],
    extra: getComparisonValueFormatter(data === null || data === void 0 ? void 0 : (_data$previousPeriod$2 = data.previousPeriod.launchTimes) === null || _data$previousPeriod$2 === void 0 ? void 0 : _data$previousPeriod$2.value),
    trendShape: _charts.MetricTrendShape.Area
  }, {
    color: euiTheme.colors.lightestShade,
    title: _i18n.i18n.translate('xpack.apm.mobile.metrics.sessions', {
      defaultMessage: 'Sessions'
    }),
    icon: getIcon('timeslider'),
    value: (_data$currentPeriod$s = data === null || data === void 0 ? void 0 : (_data$currentPeriod5 = data.currentPeriod) === null || _data$currentPeriod5 === void 0 ? void 0 : (_data$currentPeriod5$ = _data$currentPeriod5.sessions) === null || _data$currentPeriod5$ === void 0 ? void 0 : _data$currentPeriod5$.value) !== null && _data$currentPeriod$s !== void 0 ? _data$currentPeriod$s : NaN,
    valueFormatter: value => Number.isNaN(value) ? _i18n2.NOT_AVAILABLE_LABEL : valueFormatter(value),
    trend: (_data$currentPeriod$s2 = data === null || data === void 0 ? void 0 : (_data$currentPeriod6 = data.currentPeriod) === null || _data$currentPeriod6 === void 0 ? void 0 : (_data$currentPeriod6$ = _data$currentPeriod6.sessions) === null || _data$currentPeriod6$ === void 0 ? void 0 : _data$currentPeriod6$.timeseries) !== null && _data$currentPeriod$s2 !== void 0 ? _data$currentPeriod$s2 : [],
    extra: getComparisonValueFormatter(data === null || data === void 0 ? void 0 : (_data$previousPeriod$3 = data.previousPeriod.sessions) === null || _data$previousPeriod$3 === void 0 ? void 0 : _data$previousPeriod$3.value),
    trendShape: _charts.MetricTrendShape.Area
  }, {
    color: euiTheme.colors.lightestShade,
    title: _i18n.i18n.translate('xpack.apm.mobile.metrics.http.requests', {
      defaultMessage: 'HTTP requests'
    }),
    icon: getIcon('kubernetesPod'),
    extra: getComparisonValueFormatter(data === null || data === void 0 ? void 0 : (_data$previousPeriod$4 = data.previousPeriod.requests) === null || _data$previousPeriod$4 === void 0 ? void 0 : _data$previousPeriod$4.value),
    value: (_data$currentPeriod$r = data === null || data === void 0 ? void 0 : (_data$currentPeriod7 = data.currentPeriod) === null || _data$currentPeriod7 === void 0 ? void 0 : (_data$currentPeriod7$ = _data$currentPeriod7.requests) === null || _data$currentPeriod7$ === void 0 ? void 0 : _data$currentPeriod7$.value) !== null && _data$currentPeriod$r !== void 0 ? _data$currentPeriod$r : NaN,
    valueFormatter: value => Number.isNaN(value) ? _i18n2.NOT_AVAILABLE_LABEL : valueFormatter(value),
    trend: (_data$currentPeriod$r2 = data === null || data === void 0 ? void 0 : (_data$currentPeriod8 = data.currentPeriod) === null || _data$currentPeriod8 === void 0 ? void 0 : (_data$currentPeriod8$ = _data$currentPeriod8.requests) === null || _data$currentPeriod8$ === void 0 ? void 0 : _data$currentPeriod8$.timeseries) !== null && _data$currentPeriod$r2 !== void 0 ? _data$currentPeriod$r2 : [],
    trendShape: _charts.MetricTrendShape.Area
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 5
    }
  }, metrics.map((metric, key) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: key,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_metric_item.MetricItem, {
    id: key,
    data: [metric],
    isLoading: loadingStats,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }))));
}