"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getState = getState;
var _task_running = require("@kbn/task-manager-plugin/server/task_running");
var _result_type = require("../../lib/result_type");
var _is_alerting_error = require("../../lib/is_alerting_error");
var _error_with_type = require("../../lib/error_with_type");
var _errors = require("../../lib/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getState({
  runRuleResult,
  startedAt,
  ruleId,
  spaceId,
  ruleTypeId,
  logger,
  stackTraceLog,
  originalState
}) {
  return (0, _result_type.map)(runRuleResult, ({
    state
  }) => ({
    ...state,
    previousStartedAt: startedAt === null || startedAt === void 0 ? void 0 : startedAt.toISOString()
  }), err => {
    const errorSource = (0, _task_running.isUserError)(err) ? _task_running.TaskErrorSource.USER : _task_running.TaskErrorSource.FRAMEWORK;
    const errorSourceTag = `${errorSource}-error`;
    if ((0, _is_alerting_error.isAlertSavedObjectNotFoundError)(err, ruleId) || (0, _error_with_type.isClusterBlockError)(err)) {
      const message = `Executing Rule ${spaceId}:${ruleTypeId}:${ruleId} has resulted in Error: ${(0, _errors.getEsErrorMessage)(err)}`;
      logger.debug(message, {
        tags: [ruleTypeId, ruleId, 'rule-run-failed', errorSourceTag]
      });
    } else {
      const error = stackTraceLog ? stackTraceLog.message : err;
      const stack = stackTraceLog ? stackTraceLog.stackTrace : err.stack;
      const message = `Executing Rule ${spaceId}:${ruleTypeId}:${ruleId} has resulted in Error: ${(0, _errors.getEsErrorMessage)(error)} - ${stack !== null && stack !== void 0 ? stack : ''}`;
      logger.error(message, {
        tags: [ruleTypeId, ruleId, 'rule-run-failed', errorSourceTag],
        error: {
          stack_trace: stack
        }
      });
    }
    return originalState;
  });
}