"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDurationInMilliseconds = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDurationInMilliseconds = duration => {
  var _duration$match;
  const [, durationNumber, durationUnit] = (_duration$match = duration.match(_constants.DURATION_REGEX)) !== null && _duration$match !== void 0 ? _duration$match : [];
  return _momentTimezone.default.duration(durationNumber, durationUnit).asMilliseconds();
};
exports.getDurationInMilliseconds = getDurationInMilliseconds;