"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPatternAnalysisEmbeddableFactory = void 0;
var _constants = require("@kbn/aiops-log-pattern-analysis/constants");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationContainers = require("@kbn/presentation-containers");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _shared_components = require("../../shared_components");
var _initialize_pattern_analysis_controls = require("./initialize_pattern_analysis_controls");
var _get_dataview_references = require("../get_dataview_references");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/embeddables/pattern_analysis/embeddable_pattern_analysis_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function deserializeState(serializedState) {
  var _serializedState$refe;
  const state = serializedState !== null && serializedState !== void 0 && serializedState.rawState ? (0, _lodash.cloneDeep)(serializedState === null || serializedState === void 0 ? void 0 : serializedState.rawState) : {};
  // inject the reference
  const dataViewIdRef = serializedState === null || serializedState === void 0 ? void 0 : (_serializedState$refe = serializedState.references) === null || _serializedState$refe === void 0 ? void 0 : _serializedState$refe.find(ref => ref.name === _constants.PATTERN_ANALYSIS_DATA_VIEW_REF_NAME);
  // if the serializedState already contains a dataViewId, we don't want to overwrite it. (Unsaved state can cause this)
  if (dataViewIdRef && state && !state.dataViewId) {
    state.dataViewId = dataViewIdRef === null || dataViewIdRef === void 0 ? void 0 : dataViewIdRef.id;
  }
  return state;
}
const getPatternAnalysisEmbeddableFactory = getStartServices => {
  const factory = {
    type: _constants.EMBEDDABLE_PATTERN_ANALYSIS_TYPE,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      uuid,
      parentApi
    }) => {
      var _runtimeState$dataVie;
      const [coreStart, pluginStart] = await getStartServices();
      const runtimeState = deserializeState(initialState);
      const timeRangeManager = (0, _presentationPublishing.initializeTimeRangeManager)(initialState.rawState);
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const {
        patternAnalysisControlsApi,
        serializePatternAnalysisChartState,
        patternAnalysisControlsComparators
      } = (0, _initialize_pattern_analysis_controls.initializePatternAnalysisControls)(runtimeState);
      const dataLoading$ = new _rxjs.BehaviorSubject(true);
      const blockingError$ = new _rxjs.BehaviorSubject(undefined);
      const dataViews$ = new _rxjs.BehaviorSubject([await pluginStart.data.dataViews.get((_runtimeState$dataVie = runtimeState.dataViewId) !== null && _runtimeState$dataVie !== void 0 ? _runtimeState$dataVie : await pluginStart.data.dataViews.getDefaultId())]);
      const filtersApi = (0, _presentationPublishing.apiPublishesFilters)(parentApi) ? parentApi : undefined;
      function serializeState() {
        const dataViewId = patternAnalysisControlsApi.dataViewId.getValue();
        return {
          rawState: {
            ...titleManager.getLatestState(),
            ...timeRangeManager.getLatestState(),
            ...serializePatternAnalysisChartState()
          },
          references: (0, _get_dataview_references.getDataviewReferences)(dataViewId, _constants.PATTERN_ANALYSIS_DATA_VIEW_REF_NAME)
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(timeRangeManager.anyStateChange$, titleManager.anyStateChange$, patternAnalysisControlsApi.dataViewId, patternAnalysisControlsApi.fieldName, patternAnalysisControlsApi.minimumTimeRangeOption, patternAnalysisControlsApi.randomSamplerMode, patternAnalysisControlsApi.randomSamplerProbability).pipe((0, _rxjs.map)(() => undefined)),
        getComparators: () => ({
          ..._presentationPublishing.timeRangeComparators,
          ..._presentationPublishing.titleComparators,
          ...patternAnalysisControlsComparators
        }),
        onReset: lastSaved => {
          const lastState = deserializeState(lastSaved);
          timeRangeManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          patternAnalysisControlsApi.updateUserInput(lastState);
        }
      });
      const api = finalizeApi({
        ...timeRangeManager.api,
        ...titleManager.api,
        ...unsavedChangesApi,
        ...patternAnalysisControlsApi,
        getTypeDisplayName: () => _i18n.i18n.translate('xpack.aiops.patternAnalysis.typeDisplayName', {
          defaultMessage: 'pattern analysis'
        }),
        isEditingEnabled: () => true,
        onEdit: async () => {
          try {
            const {
              resolveEmbeddablePatternAnalysisUserInput
            } = await Promise.resolve().then(() => _interopRequireWildcard(require('./resolve_pattern_analysis_config_input')));
            const result = await resolveEmbeddablePatternAnalysisUserInput(coreStart, pluginStart, parentApi, uuid, false, patternAnalysisControlsApi, undefined, serializePatternAnalysisChartState());
            patternAnalysisControlsApi.updateUserInput(result);
          } catch (e) {
            return Promise.reject();
          }
        },
        dataLoading$,
        blockingError$,
        dataViews$,
        serializeState
      });
      const PatternAnalysisComponent = (0, _shared_components.getPatternAnalysisComponent)(coreStart, pluginStart);
      const onLoading = v => dataLoading$.next(v);
      const onRenderComplete = () => dataLoading$.next(false);
      const onError = error => blockingError$.next(error);
      return {
        api,
        Component: () => {
          if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
            throw new Error('Parent API does not have execution context');
          }
          const [dataViewId, fieldName, minimumTimeRangeOption, randomSamplerMode, randomSamplerProbability] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.dataViewId, api.fieldName, api.minimumTimeRangeOption, api.randomSamplerMode, api.randomSamplerProbability);
          const reload$ = (0, _react.useMemo)(() => (0, _presentationPublishing.fetch$)(api).pipe((0, _rxjs.skipWhile)(fetchContext => !fetchContext.isReload), (0, _rxjs.map)(fetchContext => Date.now())), []);
          const timeRange$ = (0, _react.useMemo)(() => (0, _presentationPublishing.fetch$)(api).pipe((0, _rxjs.map)(fetchContext => fetchContext.timeRange), (0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default)), []);
          const lastReloadRequestTime = (0, _useObservable.default)(reload$, Date.now());
          const timeRange = (0, _useObservable.default)(timeRange$, undefined);
          const embeddingOrigin = (0, _presentationPublishing.apiHasExecutionContext)(parentApi) ? parentApi.executionContext.type : undefined;
          return /*#__PURE__*/_react.default.createElement(PatternAnalysisComponent, {
            filtersApi: filtersApi,
            dataViewId: dataViewId,
            fieldName: fieldName,
            minimumTimeRangeOption: minimumTimeRangeOption,
            randomSamplerMode: randomSamplerMode,
            randomSamplerProbability: randomSamplerProbability,
            timeRange: timeRange,
            onLoading: onLoading,
            onRenderComplete: onRenderComplete,
            onError: onError,
            embeddingOrigin: embeddingOrigin,
            lastReloadRequestTime: lastReloadRequestTime,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 213,
              columnNumber: 13
            }
          });
        }
      };
    }
  };
  return factory;
};
exports.getPatternAnalysisEmbeddableFactory = getPatternAnalysisEmbeddableFactory;