"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableActionButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis_results_table/table_action_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TableActionButton = ({
  iconType,
  dataTestSubjPostfix,
  isDisabled,
  label,
  tooltipText,
  onClick
}) => {
  const buttonContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    css: {
      marginRight: '8px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }), label);
  const unwrappedButton = !isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `aiopsTableActionButton${dataTestSubjPostfix} enabled`,
    onClick: onClick,
    color: 'text',
    "aria-label": tooltipText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, buttonContent) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": `aiopsTableActionButton${dataTestSubjPostfix} disabled`,
    size: "s",
    color: 'subdued',
    "aria-label": tooltipText,
    css: {
      fontWeight: 500
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, buttonContent);
  if (tooltipText) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: tooltipText,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 12
      }
    }, unwrappedButton);
  }
  return unwrappedButton;
};
exports.TableActionButton = TableActionButton;