/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.elasticsearch.common.Strings;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

final class AggregateMapper {
    private final HashMap<Expression, List<NamedExpression>> cache = new HashMap();

    AggregateMapper() {
    }

    public List<NamedExpression> mapNonGrouping(List<? extends NamedExpression> aggregates) {
        return this.doMapping(aggregates, false);
    }

    public List<NamedExpression> mapNonGrouping(NamedExpression aggregate) {
        return this.map(aggregate, false).toList();
    }

    public List<NamedExpression> mapGrouping(List<? extends NamedExpression> aggregates) {
        return this.doMapping(aggregates, true);
    }

    private List<NamedExpression> doMapping(List<? extends NamedExpression> aggregates, boolean grouping) {
        AttributeMap.Builder attrToExpressionsBuilder = AttributeMap.builder();
        aggregates.stream().flatMap(ne -> this.map((NamedExpression)ne, grouping)).forEach(ne -> attrToExpressionsBuilder.put(ne.toAttribute(), ne));
        return attrToExpressionsBuilder.build().values().stream().toList();
    }

    public List<NamedExpression> mapGrouping(NamedExpression aggregate) {
        return this.map(aggregate, true).toList();
    }

    private Stream<NamedExpression> map(NamedExpression ne, boolean grouping) {
        return this.cache.computeIfAbsent(Alias.unwrap((Expression)ne), aggKey -> AggregateMapper.computeEntryForAgg(ne.name(), aggKey, grouping)).stream();
    }

    private static List<NamedExpression> computeEntryForAgg(String aggAlias, Expression aggregate, boolean grouping) {
        if (aggregate instanceof AggregateFunction) {
            AggregateFunction aggregateFunction = (AggregateFunction)aggregate;
            return AggregateMapper.entryForAgg(aggAlias, aggregateFunction, grouping);
        }
        if (aggregate instanceof FieldAttribute || aggregate instanceof MetadataAttribute || aggregate instanceof ReferenceAttribute) {
            return List.of();
        }
        throw new EsqlIllegalArgumentException("unknown agg: " + String.valueOf(aggregate.getClass()) + ": " + String.valueOf(aggregate));
    }

    private static List<NamedExpression> entryForAgg(String aggAlias, AggregateFunction aggregateFunction, boolean grouping) {
        if (!(aggregateFunction instanceof ToAggregator)) {
            throw new EsqlIllegalArgumentException("Aggregate has no defined intermediate state: " + String.valueOf(aggregateFunction));
        }
        ToAggregator toAggregator = (ToAggregator)((Object)aggregateFunction);
        AggregatorFunctionSupplier supplier = toAggregator.supplier();
        List intermediateState = grouping ? supplier.groupingIntermediateStateDesc() : supplier.nonGroupingIntermediateStateDesc();
        return AggregateMapper.intermediateStateToNamedExpressions(intermediateState, aggAlias).toList();
    }

    private static Stream<NamedExpression> intermediateStateToNamedExpressions(List<IntermediateStateDesc> intermediateStateDescs, String aggAlias) {
        return intermediateStateDescs.stream().map(is -> {
            DataType dataType = Strings.isEmpty((CharSequence)is.dataType()) ? AggregateMapper.toDataType(is.type()) : DataType.fromEs((String)is.dataType());
            return new ReferenceAttribute(Source.EMPTY, null, Attribute.rawTemporaryName((String[])new String[]{aggAlias, is.name()}), dataType);
        });
    }

    private static DataType toDataType(ElementType elementType) {
        return switch (elementType) {
            default -> throw new MatchException(null, null);
            case ElementType.BOOLEAN -> DataType.BOOLEAN;
            case ElementType.BYTES_REF -> DataType.KEYWORD;
            case ElementType.INT -> DataType.INTEGER;
            case ElementType.LONG -> DataType.LONG;
            case ElementType.DOUBLE -> DataType.DOUBLE;
            case ElementType.FLOAT, ElementType.NULL, ElementType.DOC, ElementType.COMPOSITE, ElementType.AGGREGATE_METRIC_DOUBLE, ElementType.UNKNOWN -> throw new EsqlIllegalArgumentException("unsupported agg type: " + String.valueOf(elementType));
        };
    }
}

