/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string.regex;

import java.io.IOException;
import java.util.function.Predicate;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RLikePattern;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.querydsl.query.RegexQuery;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.regex.RegexMatch;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class RLike
extends RegexMatch<RLikePattern> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "RLike", RLike::new);
    public static final String NAME = "RLIKE";

    @FunctionInfo(returnType={"boolean"}, description="Use `RLIKE` to filter data based on string patterns using\n<<regexp-syntax,regular expressions>>. `RLIKE` usually acts on a field placed on\nthe left-hand side of the operator, but it can also act on a constant (literal)\nexpression. The right-hand side of the operator represents the pattern.", detailedDescription="Matching special characters (eg. `.`, `*`, `(`...) will require escaping.\nThe escape character is backslash `\\`. Since also backslash is a special character in string literals,\nit will require further escaping.\n\n<<load-esql-example, file=string tag=rlikeEscapingSingleQuotes>>\n\nTo reduce the overhead of escaping, we suggest using triple quotes strings `\"\"\"`\n\n<<load-esql-example, file=string tag=rlikeEscapingTripleQuotes>>\n```{applies_to}\nstack: ga 9.2\nserverless: ga\n```\n\nBoth a single pattern or a list of patterns are supported. If a list of patterns is provided,\nthe expression will return true if any of the patterns match.\n\n<<load-esql-example, file=where-like tag=rlikeListDocExample>>\n", operator="RLIKE", examples={@Example(file="docs", tag="rlike")})
    public RLike(Source source, @Param(name="str", type={"keyword", "text"}, description="A literal value.") Expression value, @Param(name="pattern", type={"keyword", "text"}, description="A regular expression.") RLikePattern pattern) {
        this(source, value, pattern, false);
    }

    public RLike(Source source, Expression field, RLikePattern rLikePattern, boolean caseInsensitive) {
        super(source, field, rLikePattern, caseInsensitive);
    }

    private RLike(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), new RLikePattern(in.readString()), RLike.deserializeCaseInsensitivity(in));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field());
        out.writeString(((RLikePattern)this.pattern()).asJavaRegex());
        this.serializeCaseInsensitivity(out);
    }

    @Override
    public String name() {
        return NAME;
    }

    public String getWriteableName() {
        return RLike.ENTRY.name;
    }

    protected NodeInfo<RLike> info() {
        return NodeInfo.create((Node)this, RLike::new, (Object)this.field(), (Object)((RLikePattern)this.pattern()), (Object)this.caseInsensitive());
    }

    protected RLike replaceChild(Expression newChild) {
        return new RLike(this.source(), newChild, (RLikePattern)this.pattern(), this.caseInsensitive());
    }

    @Override
    public Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        FieldAttribute fa = LucenePushdownPredicates.checkIsFieldAttribute(this.field());
        return new RegexQuery(this.source(), handler.nameOf((Expression)fa.exactAttribute()), ((RLikePattern)this.pattern()).asJavaRegex(), this.caseInsensitive());
    }

    public Expression optimizeStringCasingWithInsensitiveRegexMatch(Expression unwrappedField, Predicate<String> matchesCaseFn) {
        if (!matchesCaseFn.test(((RLikePattern)this.pattern()).pattern())) {
            return Literal.of((Expression)this, (Object)Boolean.FALSE);
        }
        return new RLike(this.source(), unwrappedField, (RLikePattern)this.pattern(), true);
    }
}

